/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.UserProfile;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UserProfileMarshaller {
    private static final MarshallingInfo<String> IAMUSERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IamUserArn").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> SSHUSERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SshUsername").isBinary(false).build();
    private static final MarshallingInfo<String> SSHPUBLICKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SshPublicKey").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ALLOWSELFMANAGEMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AllowSelfManagement").isBinary(false).build();
    private static final UserProfileMarshaller INSTANCE = new UserProfileMarshaller();

    private UserProfileMarshaller() {
    }

    public static UserProfileMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UserProfile userProfile, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)userProfile, (String)"userProfile");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)userProfile.iamUserArn(), IAMUSERARN_BINDING);
            protocolMarshaller.marshall((Object)userProfile.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)userProfile.sshUsername(), SSHUSERNAME_BINDING);
            protocolMarshaller.marshall((Object)userProfile.sshPublicKey(), SSHPUBLICKEY_BINDING);
            protocolMarshaller.marshall((Object)userProfile.allowSelfManagement(), ALLOWSELFMANAGEMENT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

