/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.CreateInstanceRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateInstanceRequestModelMarshaller {
    private static final MarshallingInfo<String> STACKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StackId").isBinary(false).build();
    private static final MarshallingInfo<List> LAYERIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LayerIds").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceType").isBinary(false).build();
    private static final MarshallingInfo<String> AUTOSCALINGTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoScalingType").isBinary(false).build();
    private static final MarshallingInfo<String> HOSTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Hostname").isBinary(false).build();
    private static final MarshallingInfo<String> OS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Os").isBinary(false).build();
    private static final MarshallingInfo<String> AMIID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AmiId").isBinary(false).build();
    private static final MarshallingInfo<String> SSHKEYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SshKeyName").isBinary(false).build();
    private static final MarshallingInfo<String> AVAILABILITYZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AvailabilityZone").isBinary(false).build();
    private static final MarshallingInfo<String> VIRTUALIZATIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VirtualizationType").isBinary(false).build();
    private static final MarshallingInfo<String> SUBNETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetId").isBinary(false).build();
    private static final MarshallingInfo<String> ARCHITECTURE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Architecture").isBinary(false).build();
    private static final MarshallingInfo<String> ROOTDEVICETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RootDeviceType").isBinary(false).build();
    private static final MarshallingInfo<List> BLOCKDEVICEMAPPINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BlockDeviceMappings").isBinary(false).build();
    private static final MarshallingInfo<Boolean> INSTALLUPDATESONBOOT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstallUpdatesOnBoot").isBinary(false).build();
    private static final MarshallingInfo<Boolean> EBSOPTIMIZED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EbsOptimized").isBinary(false).build();
    private static final MarshallingInfo<String> AGENTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AgentVersion").isBinary(false).build();
    private static final MarshallingInfo<String> TENANCY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tenancy").isBinary(false).build();
    private static final CreateInstanceRequestModelMarshaller INSTANCE = new CreateInstanceRequestModelMarshaller();

    private CreateInstanceRequestModelMarshaller() {
    }

    public static CreateInstanceRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateInstanceRequest createInstanceRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createInstanceRequest), (String)"createInstanceRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createInstanceRequest.stackId(), STACKID_BINDING);
            protocolMarshaller.marshall(createInstanceRequest.layerIds(), LAYERIDS_BINDING);
            protocolMarshaller.marshall((Object)createInstanceRequest.instanceType(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)createInstanceRequest.autoScalingTypeAsString(), AUTOSCALINGTYPE_BINDING);
            protocolMarshaller.marshall((Object)createInstanceRequest.hostname(), HOSTNAME_BINDING);
            protocolMarshaller.marshall((Object)createInstanceRequest.os(), OS_BINDING);
            protocolMarshaller.marshall((Object)createInstanceRequest.amiId(), AMIID_BINDING);
            protocolMarshaller.marshall((Object)createInstanceRequest.sshKeyName(), SSHKEYNAME_BINDING);
            protocolMarshaller.marshall((Object)createInstanceRequest.availabilityZone(), AVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall((Object)createInstanceRequest.virtualizationType(), VIRTUALIZATIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)createInstanceRequest.subnetId(), SUBNETID_BINDING);
            protocolMarshaller.marshall((Object)createInstanceRequest.architectureAsString(), ARCHITECTURE_BINDING);
            protocolMarshaller.marshall((Object)createInstanceRequest.rootDeviceTypeAsString(), ROOTDEVICETYPE_BINDING);
            protocolMarshaller.marshall(createInstanceRequest.blockDeviceMappings(), BLOCKDEVICEMAPPINGS_BINDING);
            protocolMarshaller.marshall((Object)createInstanceRequest.installUpdatesOnBoot(), INSTALLUPDATESONBOOT_BINDING);
            protocolMarshaller.marshall((Object)createInstanceRequest.ebsOptimized(), EBSOPTIMIZED_BINDING);
            protocolMarshaller.marshall((Object)createInstanceRequest.agentVersion(), AGENTVERSION_BINDING);
            protocolMarshaller.marshall((Object)createInstanceRequest.tenancy(), TENANCY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

