/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.ChefConfiguration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ChefConfigurationMarshaller {
    private static final MarshallingInfo<Boolean> MANAGEBERKSHELF_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ManageBerkshelf").isBinary(false).build();
    private static final MarshallingInfo<String> BERKSHELFVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BerkshelfVersion").isBinary(false).build();
    private static final ChefConfigurationMarshaller INSTANCE = new ChefConfigurationMarshaller();

    private ChefConfigurationMarshaller() {
    }

    public static ChefConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ChefConfiguration chefConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)chefConfiguration, (String)"chefConfiguration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)chefConfiguration.manageBerkshelf(), MANAGEBERKSHELF_BINDING);
            protocolMarshaller.marshall((Object)chefConfiguration.berkshelfVersion(), BERKSHELFVERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

