/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.ShutdownEventConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ShutdownEventConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, ShutdownEventConfiguration> {
    private final Integer executionTimeout;
    private final Boolean delayUntilElbConnectionsDrained;

    private ShutdownEventConfiguration(BuilderImpl builder) {
        this.executionTimeout = builder.executionTimeout;
        this.delayUntilElbConnectionsDrained = builder.delayUntilElbConnectionsDrained;
    }

    public Integer executionTimeout() {
        return this.executionTimeout;
    }

    public Boolean delayUntilElbConnectionsDrained() {
        return this.delayUntilElbConnectionsDrained;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.executionTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.delayUntilElbConnectionsDrained());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShutdownEventConfiguration)) {
            return false;
        }
        ShutdownEventConfiguration other = (ShutdownEventConfiguration)obj;
        return Objects.equals(this.executionTimeout(), other.executionTimeout()) && Objects.equals(this.delayUntilElbConnectionsDrained(), other.delayUntilElbConnectionsDrained());
    }

    public String toString() {
        return ToString.builder((String)"ShutdownEventConfiguration").add("ExecutionTimeout", (Object)this.executionTimeout()).add("DelayUntilElbConnectionsDrained", (Object)this.delayUntilElbConnectionsDrained()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExecutionTimeout": {
                return Optional.of(clazz.cast(this.executionTimeout()));
            }
            case "DelayUntilElbConnectionsDrained": {
                return Optional.of(clazz.cast(this.delayUntilElbConnectionsDrained()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ShutdownEventConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer executionTimeout;
        private Boolean delayUntilElbConnectionsDrained;

        private BuilderImpl() {
        }

        private BuilderImpl(ShutdownEventConfiguration model) {
            this.executionTimeout(model.executionTimeout);
            this.delayUntilElbConnectionsDrained(model.delayUntilElbConnectionsDrained);
        }

        public final Integer getExecutionTimeout() {
            return this.executionTimeout;
        }

        @Override
        public final Builder executionTimeout(Integer executionTimeout) {
            this.executionTimeout = executionTimeout;
            return this;
        }

        public final void setExecutionTimeout(Integer executionTimeout) {
            this.executionTimeout = executionTimeout;
        }

        public final Boolean getDelayUntilElbConnectionsDrained() {
            return this.delayUntilElbConnectionsDrained;
        }

        @Override
        public final Builder delayUntilElbConnectionsDrained(Boolean delayUntilElbConnectionsDrained) {
            this.delayUntilElbConnectionsDrained = delayUntilElbConnectionsDrained;
            return this;
        }

        public final void setDelayUntilElbConnectionsDrained(Boolean delayUntilElbConnectionsDrained) {
            this.delayUntilElbConnectionsDrained = delayUntilElbConnectionsDrained;
        }

        public ShutdownEventConfiguration build() {
            return new ShutdownEventConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ShutdownEventConfiguration> {
        public Builder executionTimeout(Integer var1);

        public Builder delayUntilElbConnectionsDrained(Boolean var1);
    }
}

