/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.opsworks.model.OpsWorksRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RegisterVolumeRequest
extends OpsWorksRequest
implements ToCopyableBuilder<Builder, RegisterVolumeRequest> {
    private final String ec2VolumeId;
    private final String stackId;

    private RegisterVolumeRequest(BuilderImpl builder) {
        super(builder);
        this.ec2VolumeId = builder.ec2VolumeId;
        this.stackId = builder.stackId;
    }

    public String ec2VolumeId() {
        return this.ec2VolumeId;
    }

    public String stackId() {
        return this.stackId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2VolumeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterVolumeRequest)) {
            return false;
        }
        RegisterVolumeRequest other = (RegisterVolumeRequest)((Object)obj);
        return Objects.equals(this.ec2VolumeId(), other.ec2VolumeId()) && Objects.equals(this.stackId(), other.stackId());
    }

    public String toString() {
        return ToString.builder((String)"RegisterVolumeRequest").add("Ec2VolumeId", (Object)this.ec2VolumeId()).add("StackId", (Object)this.stackId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Ec2VolumeId": {
                return Optional.of(clazz.cast(this.ec2VolumeId()));
            }
            case "StackId": {
                return Optional.of(clazz.cast(this.stackId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksRequest.BuilderImpl
    implements Builder {
        private String ec2VolumeId;
        private String stackId;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterVolumeRequest model) {
            super(model);
            this.ec2VolumeId(model.ec2VolumeId);
            this.stackId(model.stackId);
        }

        public final String getEc2VolumeId() {
            return this.ec2VolumeId;
        }

        @Override
        public final Builder ec2VolumeId(String ec2VolumeId) {
            this.ec2VolumeId = ec2VolumeId;
            return this;
        }

        public final void setEc2VolumeId(String ec2VolumeId) {
            this.ec2VolumeId = ec2VolumeId;
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public RegisterVolumeRequest build() {
            return new RegisterVolumeRequest(this);
        }
    }

    public static interface Builder
    extends OpsWorksRequest.Builder,
    CopyableBuilder<Builder, RegisterVolumeRequest> {
        public Builder ec2VolumeId(String var1);

        public Builder stackId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

