/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.opsworks.model.OpsWorksRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AttachElasticLoadBalancerRequest
extends OpsWorksRequest
implements ToCopyableBuilder<Builder, AttachElasticLoadBalancerRequest> {
    private final String elasticLoadBalancerName;
    private final String layerId;

    private AttachElasticLoadBalancerRequest(BuilderImpl builder) {
        super(builder);
        this.elasticLoadBalancerName = builder.elasticLoadBalancerName;
        this.layerId = builder.layerId;
    }

    public String elasticLoadBalancerName() {
        return this.elasticLoadBalancerName;
    }

    public String layerId() {
        return this.layerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticLoadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.layerId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachElasticLoadBalancerRequest)) {
            return false;
        }
        AttachElasticLoadBalancerRequest other = (AttachElasticLoadBalancerRequest)((Object)obj);
        return Objects.equals(this.elasticLoadBalancerName(), other.elasticLoadBalancerName()) && Objects.equals(this.layerId(), other.layerId());
    }

    public String toString() {
        return ToString.builder((String)"AttachElasticLoadBalancerRequest").add("ElasticLoadBalancerName", (Object)this.elasticLoadBalancerName()).add("LayerId", (Object)this.layerId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ElasticLoadBalancerName": {
                return Optional.of(clazz.cast(this.elasticLoadBalancerName()));
            }
            case "LayerId": {
                return Optional.of(clazz.cast(this.layerId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksRequest.BuilderImpl
    implements Builder {
        private String elasticLoadBalancerName;
        private String layerId;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachElasticLoadBalancerRequest model) {
            super(model);
            this.elasticLoadBalancerName(model.elasticLoadBalancerName);
            this.layerId(model.layerId);
        }

        public final String getElasticLoadBalancerName() {
            return this.elasticLoadBalancerName;
        }

        @Override
        public final Builder elasticLoadBalancerName(String elasticLoadBalancerName) {
            this.elasticLoadBalancerName = elasticLoadBalancerName;
            return this;
        }

        public final void setElasticLoadBalancerName(String elasticLoadBalancerName) {
            this.elasticLoadBalancerName = elasticLoadBalancerName;
        }

        public final String getLayerId() {
            return this.layerId;
        }

        @Override
        public final Builder layerId(String layerId) {
            this.layerId = layerId;
            return this;
        }

        public final void setLayerId(String layerId) {
            this.layerId = layerId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public AttachElasticLoadBalancerRequest build() {
            return new AttachElasticLoadBalancerRequest(this);
        }
    }

    public static interface Builder
    extends OpsWorksRequest.Builder,
    CopyableBuilder<Builder, AttachElasticLoadBalancerRequest> {
        public Builder elasticLoadBalancerName(String var1);

        public Builder layerId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

