/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opensearchserverless.model.OpenSearchServerlessResponse;
import software.amazon.awssdk.services.opensearchserverless.model.SecurityConfigSummariesCopier;
import software.amazon.awssdk.services.opensearchserverless.model.SecurityConfigSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSecurityConfigsResponse
extends OpenSearchServerlessResponse
implements ToCopyableBuilder<Builder, ListSecurityConfigsResponse> {
    private static final SdkField<List<SecurityConfigSummary>> SECURITY_CONFIG_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("securityConfigSummaries").getter(ListSecurityConfigsResponse.getter(ListSecurityConfigsResponse::securityConfigSummaries)).setter(ListSecurityConfigsResponse.setter(Builder::securityConfigSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityConfigSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SecurityConfigSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSecurityConfigsResponse.getter(ListSecurityConfigsResponse::nextToken)).setter(ListSecurityConfigsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_CONFIG_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSecurityConfigsResponse.memberNameToFieldInitializer();
    private final List<SecurityConfigSummary> securityConfigSummaries;
    private final String nextToken;

    private ListSecurityConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.securityConfigSummaries = builder.securityConfigSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSecurityConfigSummaries() {
        return this.securityConfigSummaries != null && !(this.securityConfigSummaries instanceof SdkAutoConstructList);
    }

    public final List<SecurityConfigSummary> securityConfigSummaries() {
        return this.securityConfigSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityConfigSummaries() ? this.securityConfigSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSecurityConfigsResponse)) {
            return false;
        }
        ListSecurityConfigsResponse other = (ListSecurityConfigsResponse)((Object)obj);
        return this.hasSecurityConfigSummaries() == other.hasSecurityConfigSummaries() && Objects.equals(this.securityConfigSummaries(), other.securityConfigSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSecurityConfigsResponse").add("SecurityConfigSummaries", this.hasSecurityConfigSummaries() ? this.securityConfigSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "securityConfigSummaries": {
                return Optional.ofNullable(clazz.cast(this.securityConfigSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("securityConfigSummaries", SECURITY_CONFIG_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSecurityConfigsResponse, T> g) {
        return obj -> g.apply((ListSecurityConfigsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchServerlessResponse.BuilderImpl
    implements Builder {
        private List<SecurityConfigSummary> securityConfigSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSecurityConfigsResponse model) {
            super(model);
            this.securityConfigSummaries(model.securityConfigSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<SecurityConfigSummary.Builder> getSecurityConfigSummaries() {
            List<SecurityConfigSummary.Builder> result = SecurityConfigSummariesCopier.copyToBuilder(this.securityConfigSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityConfigSummaries(Collection<SecurityConfigSummary.BuilderImpl> securityConfigSummaries) {
            this.securityConfigSummaries = SecurityConfigSummariesCopier.copyFromBuilder(securityConfigSummaries);
        }

        @Override
        public final Builder securityConfigSummaries(Collection<SecurityConfigSummary> securityConfigSummaries) {
            this.securityConfigSummaries = SecurityConfigSummariesCopier.copy(securityConfigSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityConfigSummaries(SecurityConfigSummary ... securityConfigSummaries) {
            this.securityConfigSummaries(Arrays.asList(securityConfigSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityConfigSummaries(Consumer<SecurityConfigSummary.Builder> ... securityConfigSummaries) {
            this.securityConfigSummaries(Stream.of(securityConfigSummaries).map(c -> (SecurityConfigSummary)((SecurityConfigSummary.Builder)SecurityConfigSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSecurityConfigsResponse build() {
            return new ListSecurityConfigsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OpenSearchServerlessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSecurityConfigsResponse> {
        public Builder securityConfigSummaries(Collection<SecurityConfigSummary> var1);

        public Builder securityConfigSummaries(SecurityConfigSummary ... var1);

        public Builder securityConfigSummaries(Consumer<SecurityConfigSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

