/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearchserverless.model.IamIdentityCenterGroupAttribute;
import software.amazon.awssdk.services.opensearchserverless.model.IamIdentityCenterUserAttribute;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IamIdentityCenterConfigOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IamIdentityCenterConfigOptions> {
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceArn").getter(IamIdentityCenterConfigOptions.getter(IamIdentityCenterConfigOptions::instanceArn)).setter(IamIdentityCenterConfigOptions.setter(Builder::instanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceArn").build()}).build();
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationArn").getter(IamIdentityCenterConfigOptions.getter(IamIdentityCenterConfigOptions::applicationArn)).setter(IamIdentityCenterConfigOptions.setter(Builder::applicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationArn").build()}).build();
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationName").getter(IamIdentityCenterConfigOptions.getter(IamIdentityCenterConfigOptions::applicationName)).setter(IamIdentityCenterConfigOptions.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationName").build()}).build();
    private static final SdkField<String> APPLICATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationDescription").getter(IamIdentityCenterConfigOptions.getter(IamIdentityCenterConfigOptions::applicationDescription)).setter(IamIdentityCenterConfigOptions.setter(Builder::applicationDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationDescription").build()}).build();
    private static final SdkField<String> USER_ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userAttribute").getter(IamIdentityCenterConfigOptions.getter(IamIdentityCenterConfigOptions::userAttributeAsString)).setter(IamIdentityCenterConfigOptions.setter(Builder::userAttribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAttribute").build()}).build();
    private static final SdkField<String> GROUP_ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groupAttribute").getter(IamIdentityCenterConfigOptions.getter(IamIdentityCenterConfigOptions::groupAttributeAsString)).setter(IamIdentityCenterConfigOptions.setter(Builder::groupAttribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupAttribute").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ARN_FIELD, APPLICATION_ARN_FIELD, APPLICATION_NAME_FIELD, APPLICATION_DESCRIPTION_FIELD, USER_ATTRIBUTE_FIELD, GROUP_ATTRIBUTE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IamIdentityCenterConfigOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String instanceArn;
    private final String applicationArn;
    private final String applicationName;
    private final String applicationDescription;
    private final String userAttribute;
    private final String groupAttribute;

    private IamIdentityCenterConfigOptions(BuilderImpl builder) {
        this.instanceArn = builder.instanceArn;
        this.applicationArn = builder.applicationArn;
        this.applicationName = builder.applicationName;
        this.applicationDescription = builder.applicationDescription;
        this.userAttribute = builder.userAttribute;
        this.groupAttribute = builder.groupAttribute;
    }

    public final String instanceArn() {
        return this.instanceArn;
    }

    public final String applicationArn() {
        return this.applicationArn;
    }

    public final String applicationName() {
        return this.applicationName;
    }

    public final String applicationDescription() {
        return this.applicationDescription;
    }

    public final IamIdentityCenterUserAttribute userAttribute() {
        return IamIdentityCenterUserAttribute.fromValue(this.userAttribute);
    }

    public final String userAttributeAsString() {
        return this.userAttribute;
    }

    public final IamIdentityCenterGroupAttribute groupAttribute() {
        return IamIdentityCenterGroupAttribute.fromValue(this.groupAttribute);
    }

    public final String groupAttributeAsString() {
        return this.groupAttribute;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.userAttributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupAttributeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IamIdentityCenterConfigOptions)) {
            return false;
        }
        IamIdentityCenterConfigOptions other = (IamIdentityCenterConfigOptions)obj;
        return Objects.equals(this.instanceArn(), other.instanceArn()) && Objects.equals(this.applicationArn(), other.applicationArn()) && Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.applicationDescription(), other.applicationDescription()) && Objects.equals(this.userAttributeAsString(), other.userAttributeAsString()) && Objects.equals(this.groupAttributeAsString(), other.groupAttributeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"IamIdentityCenterConfigOptions").add("InstanceArn", (Object)this.instanceArn()).add("ApplicationArn", (Object)this.applicationArn()).add("ApplicationName", (Object)this.applicationName()).add("ApplicationDescription", (Object)this.applicationDescription()).add("UserAttribute", (Object)this.userAttributeAsString()).add("GroupAttribute", (Object)this.groupAttributeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceArn": {
                return Optional.ofNullable(clazz.cast(this.instanceArn()));
            }
            case "applicationArn": {
                return Optional.ofNullable(clazz.cast(this.applicationArn()));
            }
            case "applicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "applicationDescription": {
                return Optional.ofNullable(clazz.cast(this.applicationDescription()));
            }
            case "userAttribute": {
                return Optional.ofNullable(clazz.cast(this.userAttributeAsString()));
            }
            case "groupAttribute": {
                return Optional.ofNullable(clazz.cast(this.groupAttributeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("instanceArn", INSTANCE_ARN_FIELD);
        map.put("applicationArn", APPLICATION_ARN_FIELD);
        map.put("applicationName", APPLICATION_NAME_FIELD);
        map.put("applicationDescription", APPLICATION_DESCRIPTION_FIELD);
        map.put("userAttribute", USER_ATTRIBUTE_FIELD);
        map.put("groupAttribute", GROUP_ATTRIBUTE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IamIdentityCenterConfigOptions, T> g) {
        return obj -> g.apply((IamIdentityCenterConfigOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceArn;
        private String applicationArn;
        private String applicationName;
        private String applicationDescription;
        private String userAttribute;
        private String groupAttribute;

        private BuilderImpl() {
        }

        private BuilderImpl(IamIdentityCenterConfigOptions model) {
            this.instanceArn(model.instanceArn);
            this.applicationArn(model.applicationArn);
            this.applicationName(model.applicationName);
            this.applicationDescription(model.applicationDescription);
            this.userAttribute(model.userAttribute);
            this.groupAttribute(model.groupAttribute);
        }

        public final String getInstanceArn() {
            return this.instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final String getApplicationArn() {
            return this.applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getApplicationDescription() {
            return this.applicationDescription;
        }

        public final void setApplicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
        }

        @Override
        public final Builder applicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
            return this;
        }

        public final String getUserAttribute() {
            return this.userAttribute;
        }

        public final void setUserAttribute(String userAttribute) {
            this.userAttribute = userAttribute;
        }

        @Override
        public final Builder userAttribute(String userAttribute) {
            this.userAttribute = userAttribute;
            return this;
        }

        @Override
        public final Builder userAttribute(IamIdentityCenterUserAttribute userAttribute) {
            this.userAttribute(userAttribute == null ? null : userAttribute.toString());
            return this;
        }

        public final String getGroupAttribute() {
            return this.groupAttribute;
        }

        public final void setGroupAttribute(String groupAttribute) {
            this.groupAttribute = groupAttribute;
        }

        @Override
        public final Builder groupAttribute(String groupAttribute) {
            this.groupAttribute = groupAttribute;
            return this;
        }

        @Override
        public final Builder groupAttribute(IamIdentityCenterGroupAttribute groupAttribute) {
            this.groupAttribute(groupAttribute == null ? null : groupAttribute.toString());
            return this;
        }

        public IamIdentityCenterConfigOptions build() {
            return new IamIdentityCenterConfigOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IamIdentityCenterConfigOptions> {
        public Builder instanceArn(String var1);

        public Builder applicationArn(String var1);

        public Builder applicationName(String var1);

        public Builder applicationDescription(String var1);

        public Builder userAttribute(String var1);

        public Builder userAttribute(IamIdentityCenterUserAttribute var1);

        public Builder groupAttribute(String var1);

        public Builder groupAttribute(IamIdentityCenterGroupAttribute var1);
    }
}

