/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearchserverless.model.CollectionStatus;
import software.amazon.awssdk.services.opensearchserverless.model.CollectionType;
import software.amazon.awssdk.services.opensearchserverless.model.StandbyReplicas;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCollectionDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateCollectionDetail> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(CreateCollectionDetail.getter(CreateCollectionDetail::id)).setter(CreateCollectionDetail.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateCollectionDetail.getter(CreateCollectionDetail::name)).setter(CreateCollectionDetail.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CreateCollectionDetail.getter(CreateCollectionDetail::statusAsString)).setter(CreateCollectionDetail.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(CreateCollectionDetail.getter(CreateCollectionDetail::typeAsString)).setter(CreateCollectionDetail.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateCollectionDetail.getter(CreateCollectionDetail::description)).setter(CreateCollectionDetail.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(CreateCollectionDetail.getter(CreateCollectionDetail::arn)).setter(CreateCollectionDetail.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyArn").getter(CreateCollectionDetail.getter(CreateCollectionDetail::kmsKeyArn)).setter(CreateCollectionDetail.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()}).build();
    private static final SdkField<String> STANDBY_REPLICAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("standbyReplicas").getter(CreateCollectionDetail.getter(CreateCollectionDetail::standbyReplicasAsString)).setter(CreateCollectionDetail.setter(Builder::standbyReplicas)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("standbyReplicas").build()}).build();
    private static final SdkField<Long> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("createdDate").getter(CreateCollectionDetail.getter(CreateCollectionDetail::createdDate)).setter(CreateCollectionDetail.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()}).build();
    private static final SdkField<Long> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("lastModifiedDate").getter(CreateCollectionDetail.getter(CreateCollectionDetail::lastModifiedDate)).setter(CreateCollectionDetail.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, STATUS_FIELD, TYPE_FIELD, DESCRIPTION_FIELD, ARN_FIELD, KMS_KEY_ARN_FIELD, STANDBY_REPLICAS_FIELD, CREATED_DATE_FIELD, LAST_MODIFIED_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateCollectionDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String status;
    private final String type;
    private final String description;
    private final String arn;
    private final String kmsKeyArn;
    private final String standbyReplicas;
    private final Long createdDate;
    private final Long lastModifiedDate;

    private CreateCollectionDetail(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.status = builder.status;
        this.type = builder.type;
        this.description = builder.description;
        this.arn = builder.arn;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.standbyReplicas = builder.standbyReplicas;
        this.createdDate = builder.createdDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final CollectionStatus status() {
        return CollectionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final CollectionType type() {
        return CollectionType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String description() {
        return this.description;
    }

    public final String arn() {
        return this.arn;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final StandbyReplicas standbyReplicas() {
        return StandbyReplicas.fromValue(this.standbyReplicas);
    }

    public final String standbyReplicasAsString() {
        return this.standbyReplicas;
    }

    public final Long createdDate() {
        return this.createdDate;
    }

    public final Long lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.standbyReplicasAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCollectionDetail)) {
            return false;
        }
        CreateCollectionDetail other = (CreateCollectionDetail)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.standbyReplicasAsString(), other.standbyReplicasAsString()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCollectionDetail").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("Type", (Object)this.typeAsString()).add("Description", (Object)this.description()).add("Arn", (Object)this.arn()).add("KmsKeyArn", (Object)this.kmsKeyArn()).add("StandbyReplicas", (Object)this.standbyReplicasAsString()).add("CreatedDate", (Object)this.createdDate()).add("LastModifiedDate", (Object)this.lastModifiedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "kmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "standbyReplicas": {
                return Optional.ofNullable(clazz.cast(this.standbyReplicasAsString()));
            }
            case "createdDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "lastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("standbyReplicas", STANDBY_REPLICAS_FIELD);
        map.put("createdDate", CREATED_DATE_FIELD);
        map.put("lastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCollectionDetail, T> g) {
        return obj -> g.apply((CreateCollectionDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String status;
        private String type;
        private String description;
        private String arn;
        private String kmsKeyArn;
        private String standbyReplicas;
        private Long createdDate;
        private Long lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCollectionDetail model) {
            this.id(model.id);
            this.name(model.name);
            this.status(model.status);
            this.type(model.type);
            this.description(model.description);
            this.arn(model.arn);
            this.kmsKeyArn(model.kmsKeyArn);
            this.standbyReplicas(model.standbyReplicas);
            this.createdDate(model.createdDate);
            this.lastModifiedDate(model.lastModifiedDate);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CollectionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CollectionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final String getStandbyReplicas() {
            return this.standbyReplicas;
        }

        public final void setStandbyReplicas(String standbyReplicas) {
            this.standbyReplicas = standbyReplicas;
        }

        @Override
        public final Builder standbyReplicas(String standbyReplicas) {
            this.standbyReplicas = standbyReplicas;
            return this;
        }

        @Override
        public final Builder standbyReplicas(StandbyReplicas standbyReplicas) {
            this.standbyReplicas(standbyReplicas == null ? null : standbyReplicas.toString());
            return this;
        }

        public final Long getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(Long createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Long createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final Long getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(Long lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Long lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public CreateCollectionDetail build() {
            return new CreateCollectionDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateCollectionDetail> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(CollectionStatus var1);

        public Builder type(String var1);

        public Builder type(CollectionType var1);

        public Builder description(String var1);

        public Builder arn(String var1);

        public Builder kmsKeyArn(String var1);

        public Builder standbyReplicas(String var1);

        public Builder standbyReplicas(StandbyReplicas var1);

        public Builder createdDate(Long var1);

        public Builder lastModifiedDate(Long var1);
    }
}

