/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearchserverless.model.IamIdentityCenterGroupAttribute;
import software.amazon.awssdk.services.opensearchserverless.model.IamIdentityCenterUserAttribute;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateIamIdentityCenterConfigOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateIamIdentityCenterConfigOptions> {
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceArn").getter(CreateIamIdentityCenterConfigOptions.getter(CreateIamIdentityCenterConfigOptions::instanceArn)).setter(CreateIamIdentityCenterConfigOptions.setter(Builder::instanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceArn").build()}).build();
    private static final SdkField<String> USER_ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userAttribute").getter(CreateIamIdentityCenterConfigOptions.getter(CreateIamIdentityCenterConfigOptions::userAttributeAsString)).setter(CreateIamIdentityCenterConfigOptions.setter(Builder::userAttribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAttribute").build()}).build();
    private static final SdkField<String> GROUP_ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groupAttribute").getter(CreateIamIdentityCenterConfigOptions.getter(CreateIamIdentityCenterConfigOptions::groupAttributeAsString)).setter(CreateIamIdentityCenterConfigOptions.setter(Builder::groupAttribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupAttribute").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ARN_FIELD, USER_ATTRIBUTE_FIELD, GROUP_ATTRIBUTE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateIamIdentityCenterConfigOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String instanceArn;
    private final String userAttribute;
    private final String groupAttribute;

    private CreateIamIdentityCenterConfigOptions(BuilderImpl builder) {
        this.instanceArn = builder.instanceArn;
        this.userAttribute = builder.userAttribute;
        this.groupAttribute = builder.groupAttribute;
    }

    public final String instanceArn() {
        return this.instanceArn;
    }

    public final IamIdentityCenterUserAttribute userAttribute() {
        return IamIdentityCenterUserAttribute.fromValue(this.userAttribute);
    }

    public final String userAttributeAsString() {
        return this.userAttribute;
    }

    public final IamIdentityCenterGroupAttribute groupAttribute() {
        return IamIdentityCenterGroupAttribute.fromValue(this.groupAttribute);
    }

    public final String groupAttributeAsString() {
        return this.groupAttribute;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.userAttributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupAttributeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIamIdentityCenterConfigOptions)) {
            return false;
        }
        CreateIamIdentityCenterConfigOptions other = (CreateIamIdentityCenterConfigOptions)obj;
        return Objects.equals(this.instanceArn(), other.instanceArn()) && Objects.equals(this.userAttributeAsString(), other.userAttributeAsString()) && Objects.equals(this.groupAttributeAsString(), other.groupAttributeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateIamIdentityCenterConfigOptions").add("InstanceArn", (Object)this.instanceArn()).add("UserAttribute", (Object)this.userAttributeAsString()).add("GroupAttribute", (Object)this.groupAttributeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceArn": {
                return Optional.ofNullable(clazz.cast(this.instanceArn()));
            }
            case "userAttribute": {
                return Optional.ofNullable(clazz.cast(this.userAttributeAsString()));
            }
            case "groupAttribute": {
                return Optional.ofNullable(clazz.cast(this.groupAttributeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("instanceArn", INSTANCE_ARN_FIELD);
        map.put("userAttribute", USER_ATTRIBUTE_FIELD);
        map.put("groupAttribute", GROUP_ATTRIBUTE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIamIdentityCenterConfigOptions, T> g) {
        return obj -> g.apply((CreateIamIdentityCenterConfigOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceArn;
        private String userAttribute;
        private String groupAttribute;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIamIdentityCenterConfigOptions model) {
            this.instanceArn(model.instanceArn);
            this.userAttribute(model.userAttribute);
            this.groupAttribute(model.groupAttribute);
        }

        public final String getInstanceArn() {
            return this.instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final String getUserAttribute() {
            return this.userAttribute;
        }

        public final void setUserAttribute(String userAttribute) {
            this.userAttribute = userAttribute;
        }

        @Override
        public final Builder userAttribute(String userAttribute) {
            this.userAttribute = userAttribute;
            return this;
        }

        @Override
        public final Builder userAttribute(IamIdentityCenterUserAttribute userAttribute) {
            this.userAttribute(userAttribute == null ? null : userAttribute.toString());
            return this;
        }

        public final String getGroupAttribute() {
            return this.groupAttribute;
        }

        public final void setGroupAttribute(String groupAttribute) {
            this.groupAttribute = groupAttribute;
        }

        @Override
        public final Builder groupAttribute(String groupAttribute) {
            this.groupAttribute = groupAttribute;
            return this;
        }

        @Override
        public final Builder groupAttribute(IamIdentityCenterGroupAttribute groupAttribute) {
            this.groupAttribute(groupAttribute == null ? null : groupAttribute.toString());
            return this;
        }

        public CreateIamIdentityCenterConfigOptions build() {
            return new CreateIamIdentityCenterConfigOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateIamIdentityCenterConfigOptions> {
        public Builder instanceArn(String var1);

        public Builder userAttribute(String var1);

        public Builder userAttribute(IamIdentityCenterUserAttribute var1);

        public Builder groupAttribute(String var1);

        public Builder groupAttribute(IamIdentityCenterGroupAttribute var1);
    }
}

