/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearchserverless.model.IamIdentityCenterConfigOptions;
import software.amazon.awssdk.services.opensearchserverless.model.SamlConfigOptions;
import software.amazon.awssdk.services.opensearchserverless.model.SecurityConfigType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SecurityConfigDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SecurityConfigDetail> {
    private static final SdkField<String> CONFIG_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configVersion").getter(SecurityConfigDetail.getter(SecurityConfigDetail::configVersion)).setter(SecurityConfigDetail.setter(Builder::configVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configVersion").build()}).build();
    private static final SdkField<Long> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("createdDate").getter(SecurityConfigDetail.getter(SecurityConfigDetail::createdDate)).setter(SecurityConfigDetail.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(SecurityConfigDetail.getter(SecurityConfigDetail::description)).setter(SecurityConfigDetail.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<IamIdentityCenterConfigOptions> IAM_IDENTITY_CENTER_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("iamIdentityCenterOptions").getter(SecurityConfigDetail.getter(SecurityConfigDetail::iamIdentityCenterOptions)).setter(SecurityConfigDetail.setter(Builder::iamIdentityCenterOptions)).constructor(IamIdentityCenterConfigOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamIdentityCenterOptions").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(SecurityConfigDetail.getter(SecurityConfigDetail::id)).setter(SecurityConfigDetail.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Long> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("lastModifiedDate").getter(SecurityConfigDetail.getter(SecurityConfigDetail::lastModifiedDate)).setter(SecurityConfigDetail.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()}).build();
    private static final SdkField<SamlConfigOptions> SAML_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("samlOptions").getter(SecurityConfigDetail.getter(SecurityConfigDetail::samlOptions)).setter(SecurityConfigDetail.setter(Builder::samlOptions)).constructor(SamlConfigOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samlOptions").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(SecurityConfigDetail.getter(SecurityConfigDetail::typeAsString)).setter(SecurityConfigDetail.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_VERSION_FIELD, CREATED_DATE_FIELD, DESCRIPTION_FIELD, IAM_IDENTITY_CENTER_OPTIONS_FIELD, ID_FIELD, LAST_MODIFIED_DATE_FIELD, SAML_OPTIONS_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("configVersion", CONFIG_VERSION_FIELD);
            this.put("createdDate", CREATED_DATE_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("iamIdentityCenterOptions", IAM_IDENTITY_CENTER_OPTIONS_FIELD);
            this.put("id", ID_FIELD);
            this.put("lastModifiedDate", LAST_MODIFIED_DATE_FIELD);
            this.put("samlOptions", SAML_OPTIONS_FIELD);
            this.put("type", TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String configVersion;
    private final Long createdDate;
    private final String description;
    private final IamIdentityCenterConfigOptions iamIdentityCenterOptions;
    private final String id;
    private final Long lastModifiedDate;
    private final SamlConfigOptions samlOptions;
    private final String type;

    private SecurityConfigDetail(BuilderImpl builder) {
        this.configVersion = builder.configVersion;
        this.createdDate = builder.createdDate;
        this.description = builder.description;
        this.iamIdentityCenterOptions = builder.iamIdentityCenterOptions;
        this.id = builder.id;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.samlOptions = builder.samlOptions;
        this.type = builder.type;
    }

    public final String configVersion() {
        return this.configVersion;
    }

    public final Long createdDate() {
        return this.createdDate;
    }

    public final String description() {
        return this.description;
    }

    public final IamIdentityCenterConfigOptions iamIdentityCenterOptions() {
        return this.iamIdentityCenterOptions;
    }

    public final String id() {
        return this.id;
    }

    public final Long lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final SamlConfigOptions samlOptions() {
        return this.samlOptions;
    }

    public final SecurityConfigType type() {
        return SecurityConfigType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamIdentityCenterOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.samlOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityConfigDetail)) {
            return false;
        }
        SecurityConfigDetail other = (SecurityConfigDetail)obj;
        return Objects.equals(this.configVersion(), other.configVersion()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.iamIdentityCenterOptions(), other.iamIdentityCenterOptions()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.samlOptions(), other.samlOptions()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SecurityConfigDetail").add("ConfigVersion", (Object)this.configVersion()).add("CreatedDate", (Object)this.createdDate()).add("Description", (Object)this.description()).add("IamIdentityCenterOptions", (Object)this.iamIdentityCenterOptions()).add("Id", (Object)this.id()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("SamlOptions", (Object)this.samlOptions()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configVersion": {
                return Optional.ofNullable(clazz.cast(this.configVersion()));
            }
            case "createdDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "iamIdentityCenterOptions": {
                return Optional.ofNullable(clazz.cast(this.iamIdentityCenterOptions()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "lastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "samlOptions": {
                return Optional.ofNullable(clazz.cast(this.samlOptions()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SecurityConfigDetail, T> g) {
        return obj -> g.apply((SecurityConfigDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String configVersion;
        private Long createdDate;
        private String description;
        private IamIdentityCenterConfigOptions iamIdentityCenterOptions;
        private String id;
        private Long lastModifiedDate;
        private SamlConfigOptions samlOptions;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityConfigDetail model) {
            this.configVersion(model.configVersion);
            this.createdDate(model.createdDate);
            this.description(model.description);
            this.iamIdentityCenterOptions(model.iamIdentityCenterOptions);
            this.id(model.id);
            this.lastModifiedDate(model.lastModifiedDate);
            this.samlOptions(model.samlOptions);
            this.type(model.type);
        }

        public final String getConfigVersion() {
            return this.configVersion;
        }

        public final void setConfigVersion(String configVersion) {
            this.configVersion = configVersion;
        }

        @Override
        public final Builder configVersion(String configVersion) {
            this.configVersion = configVersion;
            return this;
        }

        public final Long getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(Long createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Long createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final IamIdentityCenterConfigOptions.Builder getIamIdentityCenterOptions() {
            return this.iamIdentityCenterOptions != null ? this.iamIdentityCenterOptions.toBuilder() : null;
        }

        public final void setIamIdentityCenterOptions(IamIdentityCenterConfigOptions.BuilderImpl iamIdentityCenterOptions) {
            this.iamIdentityCenterOptions = iamIdentityCenterOptions != null ? iamIdentityCenterOptions.build() : null;
        }

        @Override
        public final Builder iamIdentityCenterOptions(IamIdentityCenterConfigOptions iamIdentityCenterOptions) {
            this.iamIdentityCenterOptions = iamIdentityCenterOptions;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Long getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(Long lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Long lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final SamlConfigOptions.Builder getSamlOptions() {
            return this.samlOptions != null ? this.samlOptions.toBuilder() : null;
        }

        public final void setSamlOptions(SamlConfigOptions.BuilderImpl samlOptions) {
            this.samlOptions = samlOptions != null ? samlOptions.build() : null;
        }

        @Override
        public final Builder samlOptions(SamlConfigOptions samlOptions) {
            this.samlOptions = samlOptions;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SecurityConfigType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public SecurityConfigDetail build() {
            return new SecurityConfigDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SecurityConfigDetail> {
        public Builder configVersion(String var1);

        public Builder createdDate(Long var1);

        public Builder description(String var1);

        public Builder iamIdentityCenterOptions(IamIdentityCenterConfigOptions var1);

        default public Builder iamIdentityCenterOptions(Consumer<IamIdentityCenterConfigOptions.Builder> iamIdentityCenterOptions) {
            return this.iamIdentityCenterOptions((IamIdentityCenterConfigOptions)((IamIdentityCenterConfigOptions.Builder)IamIdentityCenterConfigOptions.builder().applyMutation(iamIdentityCenterOptions)).build());
        }

        public Builder id(String var1);

        public Builder lastModifiedDate(Long var1);

        public Builder samlOptions(SamlConfigOptions var1);

        default public Builder samlOptions(Consumer<SamlConfigOptions.Builder> samlOptions) {
            return this.samlOptions((SamlConfigOptions)((SamlConfigOptions.Builder)SamlConfigOptions.builder().applyMutation(samlOptions)).build());
        }

        public Builder type(String var1);

        public Builder type(SecurityConfigType var1);
    }
}

