/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opensearchserverless.model.AccessPolicySummariesCopier;
import software.amazon.awssdk.services.opensearchserverless.model.AccessPolicySummary;
import software.amazon.awssdk.services.opensearchserverless.model.OpenSearchServerlessResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAccessPoliciesResponse
extends OpenSearchServerlessResponse
implements ToCopyableBuilder<Builder, ListAccessPoliciesResponse> {
    private static final SdkField<List<AccessPolicySummary>> ACCESS_POLICY_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accessPolicySummaries").getter(ListAccessPoliciesResponse.getter(ListAccessPoliciesResponse::accessPolicySummaries)).setter(ListAccessPoliciesResponse.setter(Builder::accessPolicySummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPolicySummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccessPolicySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAccessPoliciesResponse.getter(ListAccessPoliciesResponse::nextToken)).setter(ListAccessPoliciesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POLICY_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<AccessPolicySummary> accessPolicySummaries;
    private final String nextToken;

    private ListAccessPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.accessPolicySummaries = builder.accessPolicySummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAccessPolicySummaries() {
        return this.accessPolicySummaries != null && !(this.accessPolicySummaries instanceof SdkAutoConstructList);
    }

    public final List<AccessPolicySummary> accessPolicySummaries() {
        return this.accessPolicySummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccessPolicySummaries() ? this.accessPolicySummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessPoliciesResponse)) {
            return false;
        }
        ListAccessPoliciesResponse other = (ListAccessPoliciesResponse)((Object)obj);
        return this.hasAccessPolicySummaries() == other.hasAccessPolicySummaries() && Objects.equals(this.accessPolicySummaries(), other.accessPolicySummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAccessPoliciesResponse").add("AccessPolicySummaries", this.hasAccessPolicySummaries() ? this.accessPolicySummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessPolicySummaries": {
                return Optional.ofNullable(clazz.cast(this.accessPolicySummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAccessPoliciesResponse, T> g) {
        return obj -> g.apply((ListAccessPoliciesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchServerlessResponse.BuilderImpl
    implements Builder {
        private List<AccessPolicySummary> accessPolicySummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccessPoliciesResponse model) {
            super(model);
            this.accessPolicySummaries(model.accessPolicySummaries);
            this.nextToken(model.nextToken);
        }

        public final List<AccessPolicySummary.Builder> getAccessPolicySummaries() {
            List<AccessPolicySummary.Builder> result = AccessPolicySummariesCopier.copyToBuilder(this.accessPolicySummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessPolicySummaries(Collection<AccessPolicySummary.BuilderImpl> accessPolicySummaries) {
            this.accessPolicySummaries = AccessPolicySummariesCopier.copyFromBuilder(accessPolicySummaries);
        }

        @Override
        public final Builder accessPolicySummaries(Collection<AccessPolicySummary> accessPolicySummaries) {
            this.accessPolicySummaries = AccessPolicySummariesCopier.copy(accessPolicySummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessPolicySummaries(AccessPolicySummary ... accessPolicySummaries) {
            this.accessPolicySummaries(Arrays.asList(accessPolicySummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessPolicySummaries(Consumer<AccessPolicySummary.Builder> ... accessPolicySummaries) {
            this.accessPolicySummaries(Stream.of(accessPolicySummaries).map(c -> (AccessPolicySummary)((AccessPolicySummary.Builder)AccessPolicySummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAccessPoliciesResponse build() {
            return new ListAccessPoliciesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpenSearchServerlessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAccessPoliciesResponse> {
        public Builder accessPolicySummaries(Collection<AccessPolicySummary> var1);

        public Builder accessPolicySummaries(AccessPolicySummary ... var1);

        public Builder accessPolicySummaries(Consumer<AccessPolicySummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

