/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opensearchserverless.OpenSearchServerlessClient;
import software.amazon.awssdk.services.opensearchserverless.internal.UserAgentUtils;
import software.amazon.awssdk.services.opensearchserverless.model.ListSecurityConfigsRequest;
import software.amazon.awssdk.services.opensearchserverless.model.ListSecurityConfigsResponse;

public class ListSecurityConfigsIterable
implements SdkIterable<ListSecurityConfigsResponse> {
    private final OpenSearchServerlessClient client;
    private final ListSecurityConfigsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSecurityConfigsIterable(OpenSearchServerlessClient client, ListSecurityConfigsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSecurityConfigsResponseFetcher();
    }

    public Iterator<ListSecurityConfigsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListSecurityConfigsResponseFetcher
    implements SyncPageFetcher<ListSecurityConfigsResponse> {
        private ListSecurityConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListSecurityConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSecurityConfigsResponse nextPage(ListSecurityConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListSecurityConfigsIterable.this.client.listSecurityConfigs(ListSecurityConfigsIterable.this.firstRequest);
            }
            return ListSecurityConfigsIterable.this.client.listSecurityConfigs((ListSecurityConfigsRequest)((Object)ListSecurityConfigsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

