/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SecurityPolicyStats
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SecurityPolicyStats> {
    private static final SdkField<Long> ENCRYPTION_POLICY_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("EncryptionPolicyCount").getter(SecurityPolicyStats.getter(SecurityPolicyStats::encryptionPolicyCount)).setter(SecurityPolicyStats.setter(Builder::encryptionPolicyCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionPolicyCount").build()}).build();
    private static final SdkField<Long> NETWORK_POLICY_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("NetworkPolicyCount").getter(SecurityPolicyStats.getter(SecurityPolicyStats::networkPolicyCount)).setter(SecurityPolicyStats.setter(Builder::networkPolicyCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkPolicyCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_POLICY_COUNT_FIELD, NETWORK_POLICY_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long encryptionPolicyCount;
    private final Long networkPolicyCount;

    private SecurityPolicyStats(BuilderImpl builder) {
        this.encryptionPolicyCount = builder.encryptionPolicyCount;
        this.networkPolicyCount = builder.networkPolicyCount;
    }

    public final Long encryptionPolicyCount() {
        return this.encryptionPolicyCount;
    }

    public final Long networkPolicyCount() {
        return this.networkPolicyCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionPolicyCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkPolicyCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityPolicyStats)) {
            return false;
        }
        SecurityPolicyStats other = (SecurityPolicyStats)obj;
        return Objects.equals(this.encryptionPolicyCount(), other.encryptionPolicyCount()) && Objects.equals(this.networkPolicyCount(), other.networkPolicyCount());
    }

    public final String toString() {
        return ToString.builder((String)"SecurityPolicyStats").add("EncryptionPolicyCount", (Object)this.encryptionPolicyCount()).add("NetworkPolicyCount", (Object)this.networkPolicyCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EncryptionPolicyCount": {
                return Optional.ofNullable(clazz.cast(this.encryptionPolicyCount()));
            }
            case "NetworkPolicyCount": {
                return Optional.ofNullable(clazz.cast(this.networkPolicyCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SecurityPolicyStats, T> g) {
        return obj -> g.apply((SecurityPolicyStats)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long encryptionPolicyCount;
        private Long networkPolicyCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityPolicyStats model) {
            this.encryptionPolicyCount(model.encryptionPolicyCount);
            this.networkPolicyCount(model.networkPolicyCount);
        }

        public final Long getEncryptionPolicyCount() {
            return this.encryptionPolicyCount;
        }

        public final void setEncryptionPolicyCount(Long encryptionPolicyCount) {
            this.encryptionPolicyCount = encryptionPolicyCount;
        }

        @Override
        public final Builder encryptionPolicyCount(Long encryptionPolicyCount) {
            this.encryptionPolicyCount = encryptionPolicyCount;
            return this;
        }

        public final Long getNetworkPolicyCount() {
            return this.networkPolicyCount;
        }

        public final void setNetworkPolicyCount(Long networkPolicyCount) {
            this.networkPolicyCount = networkPolicyCount;
        }

        @Override
        public final Builder networkPolicyCount(Long networkPolicyCount) {
            this.networkPolicyCount = networkPolicyCount;
            return this;
        }

        public SecurityPolicyStats build() {
            return new SecurityPolicyStats(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SecurityPolicyStats> {
        public Builder encryptionPolicyCount(Long var1);

        public Builder networkPolicyCount(Long var1);
    }
}

