/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opensearch.model.AppConfig;
import software.amazon.awssdk.services.opensearch.model.AppConfigsCopier;
import software.amazon.awssdk.services.opensearch.model.ApplicationStatus;
import software.amazon.awssdk.services.opensearch.model.DataSource;
import software.amazon.awssdk.services.opensearch.model.DataSourcesCopier;
import software.amazon.awssdk.services.opensearch.model.IamIdentityCenterOptions;
import software.amazon.awssdk.services.opensearch.model.OpenSearchResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetApplicationResponse
extends OpenSearchResponse
implements ToCopyableBuilder<Builder, GetApplicationResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetApplicationResponse.getter(GetApplicationResponse::id)).setter(GetApplicationResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetApplicationResponse.getter(GetApplicationResponse::arn)).setter(GetApplicationResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetApplicationResponse.getter(GetApplicationResponse::name)).setter(GetApplicationResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endpoint").getter(GetApplicationResponse.getter(GetApplicationResponse::endpoint)).setter(GetApplicationResponse.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetApplicationResponse.getter(GetApplicationResponse::statusAsString)).setter(GetApplicationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<IamIdentityCenterOptions> IAM_IDENTITY_CENTER_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("iamIdentityCenterOptions").getter(GetApplicationResponse.getter(GetApplicationResponse::iamIdentityCenterOptions)).setter(GetApplicationResponse.setter(Builder::iamIdentityCenterOptions)).constructor(IamIdentityCenterOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamIdentityCenterOptions").build()}).build();
    private static final SdkField<List<DataSource>> DATA_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dataSources").getter(GetApplicationResponse.getter(GetApplicationResponse::dataSources)).setter(GetApplicationResponse.setter(Builder::dataSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AppConfig>> APP_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("appConfigs").getter(GetApplicationResponse.getter(GetApplicationResponse::appConfigs)).setter(GetApplicationResponse.setter(Builder::appConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AppConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetApplicationResponse.getter(GetApplicationResponse::createdAt)).setter(GetApplicationResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(GetApplicationResponse.getter(GetApplicationResponse::lastUpdatedAt)).setter(GetApplicationResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyArn").getter(GetApplicationResponse.getter(GetApplicationResponse::kmsKeyArn)).setter(GetApplicationResponse.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, NAME_FIELD, ENDPOINT_FIELD, STATUS_FIELD, IAM_IDENTITY_CENTER_OPTIONS_FIELD, DATA_SOURCES_FIELD, APP_CONFIGS_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, KMS_KEY_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetApplicationResponse.memberNameToFieldInitializer();
    private final String id;
    private final String arn;
    private final String name;
    private final String endpoint;
    private final String status;
    private final IamIdentityCenterOptions iamIdentityCenterOptions;
    private final List<DataSource> dataSources;
    private final List<AppConfig> appConfigs;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final String kmsKeyArn;

    private GetApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.endpoint = builder.endpoint;
        this.status = builder.status;
        this.iamIdentityCenterOptions = builder.iamIdentityCenterOptions;
        this.dataSources = builder.dataSources;
        this.appConfigs = builder.appConfigs;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String endpoint() {
        return this.endpoint;
    }

    public final ApplicationStatus status() {
        return ApplicationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final IamIdentityCenterOptions iamIdentityCenterOptions() {
        return this.iamIdentityCenterOptions;
    }

    public final boolean hasDataSources() {
        return this.dataSources != null && !(this.dataSources instanceof SdkAutoConstructList);
    }

    public final List<DataSource> dataSources() {
        return this.dataSources;
    }

    public final boolean hasAppConfigs() {
        return this.appConfigs != null && !(this.appConfigs instanceof SdkAutoConstructList);
    }

    public final List<AppConfig> appConfigs() {
        return this.appConfigs;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamIdentityCenterOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataSources() ? this.dataSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAppConfigs() ? this.appConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationResponse)) {
            return false;
        }
        GetApplicationResponse other = (GetApplicationResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.iamIdentityCenterOptions(), other.iamIdentityCenterOptions()) && this.hasDataSources() == other.hasDataSources() && Objects.equals(this.dataSources(), other.dataSources()) && this.hasAppConfigs() == other.hasAppConfigs() && Objects.equals(this.appConfigs(), other.appConfigs()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn());
    }

    public final String toString() {
        return ToString.builder((String)"GetApplicationResponse").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Endpoint", (Object)this.endpoint()).add("Status", (Object)this.statusAsString()).add("IamIdentityCenterOptions", (Object)this.iamIdentityCenterOptions()).add("DataSources", this.hasDataSources() ? this.dataSources() : null).add("AppConfigs", this.hasAppConfigs() ? this.appConfigs() : null).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("KmsKeyArn", (Object)this.kmsKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "iamIdentityCenterOptions": {
                return Optional.ofNullable(clazz.cast(this.iamIdentityCenterOptions()));
            }
            case "dataSources": {
                return Optional.ofNullable(clazz.cast(this.dataSources()));
            }
            case "appConfigs": {
                return Optional.ofNullable(clazz.cast(this.appConfigs()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "kmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("endpoint", ENDPOINT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("iamIdentityCenterOptions", IAM_IDENTITY_CENTER_OPTIONS_FIELD);
        map.put("dataSources", DATA_SOURCES_FIELD);
        map.put("appConfigs", APP_CONFIGS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetApplicationResponse, T> g) {
        return obj -> g.apply((GetApplicationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchResponse.BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String name;
        private String endpoint;
        private String status;
        private IamIdentityCenterOptions iamIdentityCenterOptions;
        private List<DataSource> dataSources = DefaultSdkAutoConstructList.getInstance();
        private List<AppConfig> appConfigs = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationResponse model) {
            super(model);
            this.id(model.id);
            this.arn(model.arn);
            this.name(model.name);
            this.endpoint(model.endpoint);
            this.status(model.status);
            this.iamIdentityCenterOptions(model.iamIdentityCenterOptions);
            this.dataSources(model.dataSources);
            this.appConfigs(model.appConfigs);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.kmsKeyArn(model.kmsKeyArn);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApplicationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final IamIdentityCenterOptions.Builder getIamIdentityCenterOptions() {
            return this.iamIdentityCenterOptions != null ? this.iamIdentityCenterOptions.toBuilder() : null;
        }

        public final void setIamIdentityCenterOptions(IamIdentityCenterOptions.BuilderImpl iamIdentityCenterOptions) {
            this.iamIdentityCenterOptions = iamIdentityCenterOptions != null ? iamIdentityCenterOptions.build() : null;
        }

        @Override
        public final Builder iamIdentityCenterOptions(IamIdentityCenterOptions iamIdentityCenterOptions) {
            this.iamIdentityCenterOptions = iamIdentityCenterOptions;
            return this;
        }

        public final List<DataSource.Builder> getDataSources() {
            List<DataSource.Builder> result = DataSourcesCopier.copyToBuilder(this.dataSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataSources(Collection<DataSource.BuilderImpl> dataSources) {
            this.dataSources = DataSourcesCopier.copyFromBuilder(dataSources);
        }

        @Override
        public final Builder dataSources(Collection<DataSource> dataSources) {
            this.dataSources = DataSourcesCopier.copy(dataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(DataSource ... dataSources) {
            this.dataSources(Arrays.asList(dataSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(Consumer<DataSource.Builder> ... dataSources) {
            this.dataSources(Stream.of(dataSources).map(c -> (DataSource)((DataSource.Builder)DataSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AppConfig.Builder> getAppConfigs() {
            List<AppConfig.Builder> result = AppConfigsCopier.copyToBuilder(this.appConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppConfigs(Collection<AppConfig.BuilderImpl> appConfigs) {
            this.appConfigs = AppConfigsCopier.copyFromBuilder(appConfigs);
        }

        @Override
        public final Builder appConfigs(Collection<AppConfig> appConfigs) {
            this.appConfigs = AppConfigsCopier.copy(appConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appConfigs(AppConfig ... appConfigs) {
            this.appConfigs(Arrays.asList(appConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appConfigs(Consumer<AppConfig.Builder> ... appConfigs) {
            this.appConfigs(Stream.of(appConfigs).map(c -> (AppConfig)((AppConfig.Builder)AppConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        @Override
        public GetApplicationResponse build() {
            return new GetApplicationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OpenSearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetApplicationResponse> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder endpoint(String var1);

        public Builder status(String var1);

        public Builder status(ApplicationStatus var1);

        public Builder iamIdentityCenterOptions(IamIdentityCenterOptions var1);

        default public Builder iamIdentityCenterOptions(Consumer<IamIdentityCenterOptions.Builder> iamIdentityCenterOptions) {
            return this.iamIdentityCenterOptions((IamIdentityCenterOptions)((IamIdentityCenterOptions.Builder)IamIdentityCenterOptions.builder().applyMutation(iamIdentityCenterOptions)).build());
        }

        public Builder dataSources(Collection<DataSource> var1);

        public Builder dataSources(DataSource ... var1);

        public Builder dataSources(Consumer<DataSource.Builder> ... var1);

        public Builder appConfigs(Collection<AppConfig> var1);

        public Builder appConfigs(AppConfig ... var1);

        public Builder appConfigs(Consumer<AppConfig.Builder> ... var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder kmsKeyArn(String var1);
    }
}

