/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.AutoTuneState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoTuneStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoTuneStatus> {
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(AutoTuneStatus.getter(AutoTuneStatus::creationDate)).setter(AutoTuneStatus.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<Instant> UPDATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdateDate").getter(AutoTuneStatus.getter(AutoTuneStatus::updateDate)).setter(AutoTuneStatus.setter(Builder::updateDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateDate").build()}).build();
    private static final SdkField<Integer> UPDATE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("UpdateVersion").getter(AutoTuneStatus.getter(AutoTuneStatus::updateVersion)).setter(AutoTuneStatus.setter(Builder::updateVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateVersion").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(AutoTuneStatus.getter(AutoTuneStatus::stateAsString)).setter(AutoTuneStatus.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(AutoTuneStatus.getter(AutoTuneStatus::errorMessage)).setter(AutoTuneStatus.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<Boolean> PENDING_DELETION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PendingDeletion").getter(AutoTuneStatus.getter(AutoTuneStatus::pendingDeletion)).setter(AutoTuneStatus.setter(Builder::pendingDeletion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingDeletion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_DATE_FIELD, UPDATE_DATE_FIELD, UPDATE_VERSION_FIELD, STATE_FIELD, ERROR_MESSAGE_FIELD, PENDING_DELETION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutoTuneStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant creationDate;
    private final Instant updateDate;
    private final Integer updateVersion;
    private final String state;
    private final String errorMessage;
    private final Boolean pendingDeletion;

    private AutoTuneStatus(BuilderImpl builder) {
        this.creationDate = builder.creationDate;
        this.updateDate = builder.updateDate;
        this.updateVersion = builder.updateVersion;
        this.state = builder.state;
        this.errorMessage = builder.errorMessage;
        this.pendingDeletion = builder.pendingDeletion;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final Instant updateDate() {
        return this.updateDate;
    }

    public final Integer updateVersion() {
        return this.updateVersion;
    }

    public final AutoTuneState state() {
        return AutoTuneState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final Boolean pendingDeletion() {
        return this.pendingDeletion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingDeletion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoTuneStatus)) {
            return false;
        }
        AutoTuneStatus other = (AutoTuneStatus)obj;
        return Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.updateDate(), other.updateDate()) && Objects.equals(this.updateVersion(), other.updateVersion()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.pendingDeletion(), other.pendingDeletion());
    }

    public final String toString() {
        return ToString.builder((String)"AutoTuneStatus").add("CreationDate", (Object)this.creationDate()).add("UpdateDate", (Object)this.updateDate()).add("UpdateVersion", (Object)this.updateVersion()).add("State", (Object)this.stateAsString()).add("ErrorMessage", (Object)this.errorMessage()).add("PendingDeletion", (Object)this.pendingDeletion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "UpdateDate": {
                return Optional.ofNullable(clazz.cast(this.updateDate()));
            }
            case "UpdateVersion": {
                return Optional.ofNullable(clazz.cast(this.updateVersion()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "PendingDeletion": {
                return Optional.ofNullable(clazz.cast(this.pendingDeletion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("UpdateDate", UPDATE_DATE_FIELD);
        map.put("UpdateVersion", UPDATE_VERSION_FIELD);
        map.put("State", STATE_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        map.put("PendingDeletion", PENDING_DELETION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoTuneStatus, T> g) {
        return obj -> g.apply((AutoTuneStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant creationDate;
        private Instant updateDate;
        private Integer updateVersion;
        private String state;
        private String errorMessage;
        private Boolean pendingDeletion;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoTuneStatus model) {
            this.creationDate(model.creationDate);
            this.updateDate(model.updateDate);
            this.updateVersion(model.updateVersion);
            this.state(model.state);
            this.errorMessage(model.errorMessage);
            this.pendingDeletion(model.pendingDeletion);
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getUpdateDate() {
            return this.updateDate;
        }

        public final void setUpdateDate(Instant updateDate) {
            this.updateDate = updateDate;
        }

        @Override
        public final Builder updateDate(Instant updateDate) {
            this.updateDate = updateDate;
            return this;
        }

        public final Integer getUpdateVersion() {
            return this.updateVersion;
        }

        public final void setUpdateVersion(Integer updateVersion) {
            this.updateVersion = updateVersion;
        }

        @Override
        public final Builder updateVersion(Integer updateVersion) {
            this.updateVersion = updateVersion;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AutoTuneState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final Boolean getPendingDeletion() {
            return this.pendingDeletion;
        }

        public final void setPendingDeletion(Boolean pendingDeletion) {
            this.pendingDeletion = pendingDeletion;
        }

        @Override
        public final Builder pendingDeletion(Boolean pendingDeletion) {
            this.pendingDeletion = pendingDeletion;
            return this;
        }

        public AutoTuneStatus build() {
            return new AutoTuneStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoTuneStatus> {
        public Builder creationDate(Instant var1);

        public Builder updateDate(Instant var1);

        public Builder updateVersion(Integer var1);

        public Builder state(String var1);

        public Builder state(AutoTuneState var1);

        public Builder errorMessage(String var1);

        public Builder pendingDeletion(Boolean var1);
    }
}

