/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opensearch.model.OpenSearchRequest;
import software.amazon.awssdk.services.opensearch.model.PackageIDListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DissociatePackagesRequest
extends OpenSearchRequest
implements ToCopyableBuilder<Builder, DissociatePackagesRequest> {
    private static final SdkField<List<String>> PACKAGE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PackageList").getter(DissociatePackagesRequest.getter(DissociatePackagesRequest::packageList)).setter(DissociatePackagesRequest.setter(Builder::packageList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(DissociatePackagesRequest.getter(DissociatePackagesRequest::domainName)).setter(DissociatePackagesRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_LIST_FIELD, DOMAIN_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DissociatePackagesRequest.memberNameToFieldInitializer();
    private final List<String> packageList;
    private final String domainName;

    private DissociatePackagesRequest(BuilderImpl builder) {
        super(builder);
        this.packageList = builder.packageList;
        this.domainName = builder.domainName;
    }

    public final boolean hasPackageList() {
        return this.packageList != null && !(this.packageList instanceof SdkAutoConstructList);
    }

    public final List<String> packageList() {
        return this.packageList;
    }

    public final String domainName() {
        return this.domainName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPackageList() ? this.packageList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DissociatePackagesRequest)) {
            return false;
        }
        DissociatePackagesRequest other = (DissociatePackagesRequest)((Object)obj);
        return this.hasPackageList() == other.hasPackageList() && Objects.equals(this.packageList(), other.packageList()) && Objects.equals(this.domainName(), other.domainName());
    }

    public final String toString() {
        return ToString.builder((String)"DissociatePackagesRequest").add("PackageList", this.hasPackageList() ? this.packageList() : null).add("DomainName", (Object)this.domainName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PackageList": {
                return Optional.ofNullable(clazz.cast(this.packageList()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PackageList", PACKAGE_LIST_FIELD);
        map.put("DomainName", DOMAIN_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DissociatePackagesRequest, T> g) {
        return obj -> g.apply((DissociatePackagesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchRequest.BuilderImpl
    implements Builder {
        private List<String> packageList = DefaultSdkAutoConstructList.getInstance();
        private String domainName;

        private BuilderImpl() {
        }

        private BuilderImpl(DissociatePackagesRequest model) {
            super(model);
            this.packageList(model.packageList);
            this.domainName(model.domainName);
        }

        public final Collection<String> getPackageList() {
            if (this.packageList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.packageList;
        }

        public final void setPackageList(Collection<String> packageList) {
            this.packageList = PackageIDListCopier.copy(packageList);
        }

        @Override
        public final Builder packageList(Collection<String> packageList) {
            this.packageList = PackageIDListCopier.copy(packageList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packageList(String ... packageList) {
            this.packageList(Arrays.asList(packageList));
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DissociatePackagesRequest build() {
            return new DissociatePackagesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OpenSearchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DissociatePackagesRequest> {
        public Builder packageList(Collection<String> var1);

        public Builder packageList(String ... var1);

        public Builder domainName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

