/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.MaintenanceStatus;
import software.amazon.awssdk.services.opensearch.model.MaintenanceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DomainMaintenanceDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DomainMaintenanceDetails> {
    private static final SdkField<String> MAINTENANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaintenanceId").getter(DomainMaintenanceDetails.getter(DomainMaintenanceDetails::maintenanceId)).setter(DomainMaintenanceDetails.setter(Builder::maintenanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceId").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(DomainMaintenanceDetails.getter(DomainMaintenanceDetails::domainName)).setter(DomainMaintenanceDetails.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(DomainMaintenanceDetails.getter(DomainMaintenanceDetails::actionAsString)).setter(DomainMaintenanceDetails.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<String> NODE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeId").getter(DomainMaintenanceDetails.getter(DomainMaintenanceDetails::nodeId)).setter(DomainMaintenanceDetails.setter(Builder::nodeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DomainMaintenanceDetails.getter(DomainMaintenanceDetails::statusAsString)).setter(DomainMaintenanceDetails.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(DomainMaintenanceDetails.getter(DomainMaintenanceDetails::statusMessage)).setter(DomainMaintenanceDetails.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(DomainMaintenanceDetails.getter(DomainMaintenanceDetails::createdAt)).setter(DomainMaintenanceDetails.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(DomainMaintenanceDetails.getter(DomainMaintenanceDetails::updatedAt)).setter(DomainMaintenanceDetails.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAINTENANCE_ID_FIELD, DOMAIN_NAME_FIELD, ACTION_FIELD, NODE_ID_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DomainMaintenanceDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String maintenanceId;
    private final String domainName;
    private final String action;
    private final String nodeId;
    private final String status;
    private final String statusMessage;
    private final Instant createdAt;
    private final Instant updatedAt;

    private DomainMaintenanceDetails(BuilderImpl builder) {
        this.maintenanceId = builder.maintenanceId;
        this.domainName = builder.domainName;
        this.action = builder.action;
        this.nodeId = builder.nodeId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    public final String maintenanceId() {
        return this.maintenanceId;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final MaintenanceType action() {
        return MaintenanceType.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final String nodeId() {
        return this.nodeId;
    }

    public final MaintenanceStatus status() {
        return MaintenanceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainMaintenanceDetails)) {
            return false;
        }
        DomainMaintenanceDetails other = (DomainMaintenanceDetails)obj;
        return Objects.equals(this.maintenanceId(), other.maintenanceId()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.nodeId(), other.nodeId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"DomainMaintenanceDetails").add("MaintenanceId", (Object)this.maintenanceId()).add("DomainName", (Object)this.domainName()).add("Action", (Object)this.actionAsString()).add("NodeId", (Object)this.nodeId()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaintenanceId": {
                return Optional.ofNullable(clazz.cast(this.maintenanceId()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "NodeId": {
                return Optional.ofNullable(clazz.cast(this.nodeId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MaintenanceId", MAINTENANCE_ID_FIELD);
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("Action", ACTION_FIELD);
        map.put("NodeId", NODE_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DomainMaintenanceDetails, T> g) {
        return obj -> g.apply((DomainMaintenanceDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String maintenanceId;
        private String domainName;
        private String action;
        private String nodeId;
        private String status;
        private String statusMessage;
        private Instant createdAt;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainMaintenanceDetails model) {
            this.maintenanceId(model.maintenanceId);
            this.domainName(model.domainName);
            this.action(model.action);
            this.nodeId(model.nodeId);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
        }

        public final String getMaintenanceId() {
            return this.maintenanceId;
        }

        public final void setMaintenanceId(String maintenanceId) {
            this.maintenanceId = maintenanceId;
        }

        @Override
        public final Builder maintenanceId(String maintenanceId) {
            this.maintenanceId = maintenanceId;
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(MaintenanceType action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getNodeId() {
            return this.nodeId;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MaintenanceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public DomainMaintenanceDetails build() {
            return new DomainMaintenanceDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DomainMaintenanceDetails> {
        public Builder maintenanceId(String var1);

        public Builder domainName(String var1);

        public Builder action(String var1);

        public Builder action(MaintenanceType var1);

        public Builder nodeId(String var1);

        public Builder status(String var1);

        public Builder status(MaintenanceStatus var1);

        public Builder statusMessage(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);
    }
}

