/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.ConnectionMode;
import software.amazon.awssdk.services.opensearch.model.DomainInformationContainer;
import software.amazon.awssdk.services.opensearch.model.InboundConnectionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InboundConnection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InboundConnection> {
    private static final SdkField<DomainInformationContainer> LOCAL_DOMAIN_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LocalDomainInfo").getter(InboundConnection.getter(InboundConnection::localDomainInfo)).setter(InboundConnection.setter(Builder::localDomainInfo)).constructor(DomainInformationContainer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalDomainInfo").build()}).build();
    private static final SdkField<DomainInformationContainer> REMOTE_DOMAIN_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RemoteDomainInfo").getter(InboundConnection.getter(InboundConnection::remoteDomainInfo)).setter(InboundConnection.setter(Builder::remoteDomainInfo)).constructor(DomainInformationContainer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteDomainInfo").build()}).build();
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionId").getter(InboundConnection.getter(InboundConnection::connectionId)).setter(InboundConnection.setter(Builder::connectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionId").build()}).build();
    private static final SdkField<InboundConnectionStatus> CONNECTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConnectionStatus").getter(InboundConnection.getter(InboundConnection::connectionStatus)).setter(InboundConnection.setter(Builder::connectionStatus)).constructor(InboundConnectionStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionStatus").build()}).build();
    private static final SdkField<String> CONNECTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionMode").getter(InboundConnection.getter(InboundConnection::connectionModeAsString)).setter(InboundConnection.setter(Builder::connectionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCAL_DOMAIN_INFO_FIELD, REMOTE_DOMAIN_INFO_FIELD, CONNECTION_ID_FIELD, CONNECTION_STATUS_FIELD, CONNECTION_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InboundConnection.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DomainInformationContainer localDomainInfo;
    private final DomainInformationContainer remoteDomainInfo;
    private final String connectionId;
    private final InboundConnectionStatus connectionStatus;
    private final String connectionMode;

    private InboundConnection(BuilderImpl builder) {
        this.localDomainInfo = builder.localDomainInfo;
        this.remoteDomainInfo = builder.remoteDomainInfo;
        this.connectionId = builder.connectionId;
        this.connectionStatus = builder.connectionStatus;
        this.connectionMode = builder.connectionMode;
    }

    public final DomainInformationContainer localDomainInfo() {
        return this.localDomainInfo;
    }

    public final DomainInformationContainer remoteDomainInfo() {
        return this.remoteDomainInfo;
    }

    public final String connectionId() {
        return this.connectionId;
    }

    public final InboundConnectionStatus connectionStatus() {
        return this.connectionStatus;
    }

    public final ConnectionMode connectionMode() {
        return ConnectionMode.fromValue(this.connectionMode);
    }

    public final String connectionModeAsString() {
        return this.connectionMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.localDomainInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteDomainInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InboundConnection)) {
            return false;
        }
        InboundConnection other = (InboundConnection)obj;
        return Objects.equals(this.localDomainInfo(), other.localDomainInfo()) && Objects.equals(this.remoteDomainInfo(), other.remoteDomainInfo()) && Objects.equals(this.connectionId(), other.connectionId()) && Objects.equals(this.connectionStatus(), other.connectionStatus()) && Objects.equals(this.connectionModeAsString(), other.connectionModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"InboundConnection").add("LocalDomainInfo", (Object)this.localDomainInfo()).add("RemoteDomainInfo", (Object)this.remoteDomainInfo()).add("ConnectionId", (Object)this.connectionId()).add("ConnectionStatus", (Object)this.connectionStatus()).add("ConnectionMode", (Object)this.connectionModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LocalDomainInfo": {
                return Optional.ofNullable(clazz.cast(this.localDomainInfo()));
            }
            case "RemoteDomainInfo": {
                return Optional.ofNullable(clazz.cast(this.remoteDomainInfo()));
            }
            case "ConnectionId": {
                return Optional.ofNullable(clazz.cast(this.connectionId()));
            }
            case "ConnectionStatus": {
                return Optional.ofNullable(clazz.cast(this.connectionStatus()));
            }
            case "ConnectionMode": {
                return Optional.ofNullable(clazz.cast(this.connectionModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LocalDomainInfo", LOCAL_DOMAIN_INFO_FIELD);
        map.put("RemoteDomainInfo", REMOTE_DOMAIN_INFO_FIELD);
        map.put("ConnectionId", CONNECTION_ID_FIELD);
        map.put("ConnectionStatus", CONNECTION_STATUS_FIELD);
        map.put("ConnectionMode", CONNECTION_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InboundConnection, T> g) {
        return obj -> g.apply((InboundConnection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DomainInformationContainer localDomainInfo;
        private DomainInformationContainer remoteDomainInfo;
        private String connectionId;
        private InboundConnectionStatus connectionStatus;
        private String connectionMode;

        private BuilderImpl() {
        }

        private BuilderImpl(InboundConnection model) {
            this.localDomainInfo(model.localDomainInfo);
            this.remoteDomainInfo(model.remoteDomainInfo);
            this.connectionId(model.connectionId);
            this.connectionStatus(model.connectionStatus);
            this.connectionMode(model.connectionMode);
        }

        public final DomainInformationContainer.Builder getLocalDomainInfo() {
            return this.localDomainInfo != null ? this.localDomainInfo.toBuilder() : null;
        }

        public final void setLocalDomainInfo(DomainInformationContainer.BuilderImpl localDomainInfo) {
            this.localDomainInfo = localDomainInfo != null ? localDomainInfo.build() : null;
        }

        @Override
        public final Builder localDomainInfo(DomainInformationContainer localDomainInfo) {
            this.localDomainInfo = localDomainInfo;
            return this;
        }

        public final DomainInformationContainer.Builder getRemoteDomainInfo() {
            return this.remoteDomainInfo != null ? this.remoteDomainInfo.toBuilder() : null;
        }

        public final void setRemoteDomainInfo(DomainInformationContainer.BuilderImpl remoteDomainInfo) {
            this.remoteDomainInfo = remoteDomainInfo != null ? remoteDomainInfo.build() : null;
        }

        @Override
        public final Builder remoteDomainInfo(DomainInformationContainer remoteDomainInfo) {
            this.remoteDomainInfo = remoteDomainInfo;
            return this;
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final InboundConnectionStatus.Builder getConnectionStatus() {
            return this.connectionStatus != null ? this.connectionStatus.toBuilder() : null;
        }

        public final void setConnectionStatus(InboundConnectionStatus.BuilderImpl connectionStatus) {
            this.connectionStatus = connectionStatus != null ? connectionStatus.build() : null;
        }

        @Override
        public final Builder connectionStatus(InboundConnectionStatus connectionStatus) {
            this.connectionStatus = connectionStatus;
            return this;
        }

        public final String getConnectionMode() {
            return this.connectionMode;
        }

        public final void setConnectionMode(String connectionMode) {
            this.connectionMode = connectionMode;
        }

        @Override
        public final Builder connectionMode(String connectionMode) {
            this.connectionMode = connectionMode;
            return this;
        }

        @Override
        public final Builder connectionMode(ConnectionMode connectionMode) {
            this.connectionMode(connectionMode == null ? null : connectionMode.toString());
            return this;
        }

        public InboundConnection build() {
            return new InboundConnection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InboundConnection> {
        public Builder localDomainInfo(DomainInformationContainer var1);

        default public Builder localDomainInfo(Consumer<DomainInformationContainer.Builder> localDomainInfo) {
            return this.localDomainInfo((DomainInformationContainer)((DomainInformationContainer.Builder)DomainInformationContainer.builder().applyMutation(localDomainInfo)).build());
        }

        public Builder remoteDomainInfo(DomainInformationContainer var1);

        default public Builder remoteDomainInfo(Consumer<DomainInformationContainer.Builder> remoteDomainInfo) {
            return this.remoteDomainInfo((DomainInformationContainer)((DomainInformationContainer.Builder)DomainInformationContainer.builder().applyMutation(remoteDomainInfo)).build());
        }

        public Builder connectionId(String var1);

        public Builder connectionStatus(InboundConnectionStatus var1);

        default public Builder connectionStatus(Consumer<InboundConnectionStatus.Builder> connectionStatus) {
            return this.connectionStatus((InboundConnectionStatus)((InboundConnectionStatus.Builder)InboundConnectionStatus.builder().applyMutation(connectionStatus)).build());
        }

        public Builder connectionMode(String var1);

        public Builder connectionMode(ConnectionMode var1);
    }
}

