/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opensearch.model.CompatibleVersionsListCopier;
import software.amazon.awssdk.services.opensearch.model.CompatibleVersionsMap;
import software.amazon.awssdk.services.opensearch.model.OpenSearchResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCompatibleVersionsResponse
extends OpenSearchResponse
implements ToCopyableBuilder<Builder, GetCompatibleVersionsResponse> {
    private static final SdkField<List<CompatibleVersionsMap>> COMPATIBLE_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CompatibleVersions").getter(GetCompatibleVersionsResponse.getter(GetCompatibleVersionsResponse::compatibleVersions)).setter(GetCompatibleVersionsResponse.setter(Builder::compatibleVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompatibleVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CompatibleVersionsMap::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPATIBLE_VERSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCompatibleVersionsResponse.memberNameToFieldInitializer();
    private final List<CompatibleVersionsMap> compatibleVersions;

    private GetCompatibleVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.compatibleVersions = builder.compatibleVersions;
    }

    public final boolean hasCompatibleVersions() {
        return this.compatibleVersions != null && !(this.compatibleVersions instanceof SdkAutoConstructList);
    }

    public final List<CompatibleVersionsMap> compatibleVersions() {
        return this.compatibleVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCompatibleVersions() ? this.compatibleVersions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCompatibleVersionsResponse)) {
            return false;
        }
        GetCompatibleVersionsResponse other = (GetCompatibleVersionsResponse)((Object)obj);
        return this.hasCompatibleVersions() == other.hasCompatibleVersions() && Objects.equals(this.compatibleVersions(), other.compatibleVersions());
    }

    public final String toString() {
        return ToString.builder((String)"GetCompatibleVersionsResponse").add("CompatibleVersions", this.hasCompatibleVersions() ? this.compatibleVersions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CompatibleVersions": {
                return Optional.ofNullable(clazz.cast(this.compatibleVersions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<CompatibleVersionsMap>>> map = new HashMap<String, SdkField<List<CompatibleVersionsMap>>>();
        map.put("CompatibleVersions", COMPATIBLE_VERSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCompatibleVersionsResponse, T> g) {
        return obj -> g.apply((GetCompatibleVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchResponse.BuilderImpl
    implements Builder {
        private List<CompatibleVersionsMap> compatibleVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCompatibleVersionsResponse model) {
            super(model);
            this.compatibleVersions(model.compatibleVersions);
        }

        public final List<CompatibleVersionsMap.Builder> getCompatibleVersions() {
            List<CompatibleVersionsMap.Builder> result = CompatibleVersionsListCopier.copyToBuilder(this.compatibleVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCompatibleVersions(Collection<CompatibleVersionsMap.BuilderImpl> compatibleVersions) {
            this.compatibleVersions = CompatibleVersionsListCopier.copyFromBuilder(compatibleVersions);
        }

        @Override
        public final Builder compatibleVersions(Collection<CompatibleVersionsMap> compatibleVersions) {
            this.compatibleVersions = CompatibleVersionsListCopier.copy(compatibleVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleVersions(CompatibleVersionsMap ... compatibleVersions) {
            this.compatibleVersions(Arrays.asList(compatibleVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleVersions(Consumer<CompatibleVersionsMap.Builder> ... compatibleVersions) {
            this.compatibleVersions(Stream.of(compatibleVersions).map(c -> (CompatibleVersionsMap)((CompatibleVersionsMap.Builder)CompatibleVersionsMap.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetCompatibleVersionsResponse build() {
            return new GetCompatibleVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OpenSearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCompatibleVersionsResponse> {
        public Builder compatibleVersions(Collection<CompatibleVersionsMap> var1);

        public Builder compatibleVersions(CompatibleVersionsMap ... var1);

        public Builder compatibleVersions(Consumer<CompatibleVersionsMap.Builder> ... var1);
    }
}

