/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opensearch.model.DomainMaintenanceDetails;
import software.amazon.awssdk.services.opensearch.model.DomainMaintenanceListCopier;
import software.amazon.awssdk.services.opensearch.model.OpenSearchResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDomainMaintenancesResponse
extends OpenSearchResponse
implements ToCopyableBuilder<Builder, ListDomainMaintenancesResponse> {
    private static final SdkField<List<DomainMaintenanceDetails>> DOMAIN_MAINTENANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DomainMaintenances").getter(ListDomainMaintenancesResponse.getter(ListDomainMaintenancesResponse::domainMaintenances)).setter(ListDomainMaintenancesResponse.setter(Builder::domainMaintenances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainMaintenances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DomainMaintenanceDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDomainMaintenancesResponse.getter(ListDomainMaintenancesResponse::nextToken)).setter(ListDomainMaintenancesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_MAINTENANCES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDomainMaintenancesResponse.memberNameToFieldInitializer();
    private final List<DomainMaintenanceDetails> domainMaintenances;
    private final String nextToken;

    private ListDomainMaintenancesResponse(BuilderImpl builder) {
        super(builder);
        this.domainMaintenances = builder.domainMaintenances;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDomainMaintenances() {
        return this.domainMaintenances != null && !(this.domainMaintenances instanceof SdkAutoConstructList);
    }

    public final List<DomainMaintenanceDetails> domainMaintenances() {
        return this.domainMaintenances;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomainMaintenances() ? this.domainMaintenances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainMaintenancesResponse)) {
            return false;
        }
        ListDomainMaintenancesResponse other = (ListDomainMaintenancesResponse)((Object)obj);
        return this.hasDomainMaintenances() == other.hasDomainMaintenances() && Objects.equals(this.domainMaintenances(), other.domainMaintenances()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDomainMaintenancesResponse").add("DomainMaintenances", this.hasDomainMaintenances() ? this.domainMaintenances() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainMaintenances": {
                return Optional.ofNullable(clazz.cast(this.domainMaintenances()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DomainMaintenances", DOMAIN_MAINTENANCES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDomainMaintenancesResponse, T> g) {
        return obj -> g.apply((ListDomainMaintenancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchResponse.BuilderImpl
    implements Builder {
        private List<DomainMaintenanceDetails> domainMaintenances = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDomainMaintenancesResponse model) {
            super(model);
            this.domainMaintenances(model.domainMaintenances);
            this.nextToken(model.nextToken);
        }

        public final List<DomainMaintenanceDetails.Builder> getDomainMaintenances() {
            List<DomainMaintenanceDetails.Builder> result = DomainMaintenanceListCopier.copyToBuilder(this.domainMaintenances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomainMaintenances(Collection<DomainMaintenanceDetails.BuilderImpl> domainMaintenances) {
            this.domainMaintenances = DomainMaintenanceListCopier.copyFromBuilder(domainMaintenances);
        }

        @Override
        public final Builder domainMaintenances(Collection<DomainMaintenanceDetails> domainMaintenances) {
            this.domainMaintenances = DomainMaintenanceListCopier.copy(domainMaintenances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainMaintenances(DomainMaintenanceDetails ... domainMaintenances) {
            this.domainMaintenances(Arrays.asList(domainMaintenances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainMaintenances(Consumer<DomainMaintenanceDetails.Builder> ... domainMaintenances) {
            this.domainMaintenances(Stream.of(domainMaintenances).map(c -> (DomainMaintenanceDetails)((DomainMaintenanceDetails.Builder)DomainMaintenanceDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDomainMaintenancesResponse build() {
            return new ListDomainMaintenancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OpenSearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDomainMaintenancesResponse> {
        public Builder domainMaintenances(Collection<DomainMaintenanceDetails> var1);

        public Builder domainMaintenances(DomainMaintenanceDetails ... var1);

        public Builder domainMaintenances(Consumer<DomainMaintenanceDetails.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

