/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.PluginProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PackageVersionHistory
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PackageVersionHistory> {
    private static final SdkField<String> PACKAGE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageVersion").getter(PackageVersionHistory.getter(PackageVersionHistory::packageVersion)).setter(PackageVersionHistory.setter(Builder::packageVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageVersion").build()}).build();
    private static final SdkField<String> COMMIT_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CommitMessage").getter(PackageVersionHistory.getter(PackageVersionHistory::commitMessage)).setter(PackageVersionHistory.setter(Builder::commitMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommitMessage").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(PackageVersionHistory.getter(PackageVersionHistory::createdAt)).setter(PackageVersionHistory.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<PluginProperties> PLUGIN_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PluginProperties").getter(PackageVersionHistory.getter(PackageVersionHistory::pluginProperties)).setter(PackageVersionHistory.setter(Builder::pluginProperties)).constructor(PluginProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PluginProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_VERSION_FIELD, COMMIT_MESSAGE_FIELD, CREATED_AT_FIELD, PLUGIN_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("PackageVersion", PACKAGE_VERSION_FIELD);
            this.put("CommitMessage", COMMIT_MESSAGE_FIELD);
            this.put("CreatedAt", CREATED_AT_FIELD);
            this.put("PluginProperties", PLUGIN_PROPERTIES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String packageVersion;
    private final String commitMessage;
    private final Instant createdAt;
    private final PluginProperties pluginProperties;

    private PackageVersionHistory(BuilderImpl builder) {
        this.packageVersion = builder.packageVersion;
        this.commitMessage = builder.commitMessage;
        this.createdAt = builder.createdAt;
        this.pluginProperties = builder.pluginProperties;
    }

    public final String packageVersion() {
        return this.packageVersion;
    }

    public final String commitMessage() {
        return this.commitMessage;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final PluginProperties pluginProperties() {
        return this.pluginProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.packageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.commitMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.pluginProperties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageVersionHistory)) {
            return false;
        }
        PackageVersionHistory other = (PackageVersionHistory)obj;
        return Objects.equals(this.packageVersion(), other.packageVersion()) && Objects.equals(this.commitMessage(), other.commitMessage()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.pluginProperties(), other.pluginProperties());
    }

    public final String toString() {
        return ToString.builder((String)"PackageVersionHistory").add("PackageVersion", (Object)this.packageVersion()).add("CommitMessage", (Object)this.commitMessage()).add("CreatedAt", (Object)this.createdAt()).add("PluginProperties", (Object)this.pluginProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PackageVersion": {
                return Optional.ofNullable(clazz.cast(this.packageVersion()));
            }
            case "CommitMessage": {
                return Optional.ofNullable(clazz.cast(this.commitMessage()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "PluginProperties": {
                return Optional.ofNullable(clazz.cast(this.pluginProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PackageVersionHistory, T> g) {
        return obj -> g.apply((PackageVersionHistory)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String packageVersion;
        private String commitMessage;
        private Instant createdAt;
        private PluginProperties pluginProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageVersionHistory model) {
            this.packageVersion(model.packageVersion);
            this.commitMessage(model.commitMessage);
            this.createdAt(model.createdAt);
            this.pluginProperties(model.pluginProperties);
        }

        public final String getPackageVersion() {
            return this.packageVersion;
        }

        public final void setPackageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
        }

        @Override
        public final Builder packageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        public final String getCommitMessage() {
            return this.commitMessage;
        }

        public final void setCommitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
        }

        @Override
        public final Builder commitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final PluginProperties.Builder getPluginProperties() {
            return this.pluginProperties != null ? this.pluginProperties.toBuilder() : null;
        }

        public final void setPluginProperties(PluginProperties.BuilderImpl pluginProperties) {
            this.pluginProperties = pluginProperties != null ? pluginProperties.build() : null;
        }

        @Override
        public final Builder pluginProperties(PluginProperties pluginProperties) {
            this.pluginProperties = pluginProperties;
            return this;
        }

        public PackageVersionHistory build() {
            return new PackageVersionHistory(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PackageVersionHistory> {
        public Builder packageVersion(String var1);

        public Builder commitMessage(String var1);

        public Builder createdAt(Instant var1);

        public Builder pluginProperties(PluginProperties var1);

        default public Builder pluginProperties(Consumer<PluginProperties.Builder> pluginProperties) {
            return this.pluginProperties((PluginProperties)((PluginProperties.Builder)PluginProperties.builder().applyMutation(pluginProperties)).build());
        }
    }
}

