/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opensearch.model.DirectQueryDataSource;
import software.amazon.awssdk.services.opensearch.model.DirectQueryDataSourceListCopier;
import software.amazon.awssdk.services.opensearch.model.OpenSearchResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDirectQueryDataSourcesResponse
extends OpenSearchResponse
implements ToCopyableBuilder<Builder, ListDirectQueryDataSourcesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDirectQueryDataSourcesResponse.getter(ListDirectQueryDataSourcesResponse::nextToken)).setter(ListDirectQueryDataSourcesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<DirectQueryDataSource>> DIRECT_QUERY_DATA_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DirectQueryDataSources").getter(ListDirectQueryDataSourcesResponse.getter(ListDirectQueryDataSourcesResponse::directQueryDataSources)).setter(ListDirectQueryDataSourcesResponse.setter(Builder::directQueryDataSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectQueryDataSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DirectQueryDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, DIRECT_QUERY_DATA_SOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("DirectQueryDataSources", DIRECT_QUERY_DATA_SOURCES_FIELD);
        }
    });
    private final String nextToken;
    private final List<DirectQueryDataSource> directQueryDataSources;

    private ListDirectQueryDataSourcesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.directQueryDataSources = builder.directQueryDataSources;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasDirectQueryDataSources() {
        return this.directQueryDataSources != null && !(this.directQueryDataSources instanceof SdkAutoConstructList);
    }

    public final List<DirectQueryDataSource> directQueryDataSources() {
        return this.directQueryDataSources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDirectQueryDataSources() ? this.directQueryDataSources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDirectQueryDataSourcesResponse)) {
            return false;
        }
        ListDirectQueryDataSourcesResponse other = (ListDirectQueryDataSourcesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasDirectQueryDataSources() == other.hasDirectQueryDataSources() && Objects.equals(this.directQueryDataSources(), other.directQueryDataSources());
    }

    public final String toString() {
        return ToString.builder((String)"ListDirectQueryDataSourcesResponse").add("NextToken", (Object)this.nextToken()).add("DirectQueryDataSources", this.hasDirectQueryDataSources() ? this.directQueryDataSources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "DirectQueryDataSources": {
                return Optional.ofNullable(clazz.cast(this.directQueryDataSources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListDirectQueryDataSourcesResponse, T> g) {
        return obj -> g.apply((ListDirectQueryDataSourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<DirectQueryDataSource> directQueryDataSources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListDirectQueryDataSourcesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.directQueryDataSources(model.directQueryDataSources);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<DirectQueryDataSource.Builder> getDirectQueryDataSources() {
            List<DirectQueryDataSource.Builder> result = DirectQueryDataSourceListCopier.copyToBuilder(this.directQueryDataSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDirectQueryDataSources(Collection<DirectQueryDataSource.BuilderImpl> directQueryDataSources) {
            this.directQueryDataSources = DirectQueryDataSourceListCopier.copyFromBuilder(directQueryDataSources);
        }

        @Override
        public final Builder directQueryDataSources(Collection<DirectQueryDataSource> directQueryDataSources) {
            this.directQueryDataSources = DirectQueryDataSourceListCopier.copy(directQueryDataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directQueryDataSources(DirectQueryDataSource ... directQueryDataSources) {
            this.directQueryDataSources(Arrays.asList(directQueryDataSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directQueryDataSources(Consumer<DirectQueryDataSource.Builder> ... directQueryDataSources) {
            this.directQueryDataSources(Stream.of(directQueryDataSources).map(c -> (DirectQueryDataSource)((DirectQueryDataSource.Builder)DirectQueryDataSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListDirectQueryDataSourcesResponse build() {
            return new ListDirectQueryDataSourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OpenSearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDirectQueryDataSourcesResponse> {
        public Builder nextToken(String var1);

        public Builder directQueryDataSources(Collection<DirectQueryDataSource> var1);

        public Builder directQueryDataSources(DirectQueryDataSource ... var1);

        public Builder directQueryDataSources(Consumer<DirectQueryDataSource.Builder> ... var1);
    }
}

