/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opensearch.model.ApplicationStatus;
import software.amazon.awssdk.services.opensearch.model.ApplicationStatusesCopier;
import software.amazon.awssdk.services.opensearch.model.OpenSearchRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListApplicationsRequest
extends OpenSearchRequest
implements ToCopyableBuilder<Builder, ListApplicationsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListApplicationsRequest.getter(ListApplicationsRequest::nextToken)).setter(ListApplicationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<List<String>> STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("statuses").getter(ListApplicationsRequest.getter(ListApplicationsRequest::statusesAsStrings)).setter(ListApplicationsRequest.setter(Builder::statusesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("statuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListApplicationsRequest.getter(ListApplicationsRequest::maxResults)).setter(ListApplicationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, STATUSES_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("statuses", STATUSES_FIELD);
            this.put("maxResults", MAX_RESULTS_FIELD);
        }
    });
    private final String nextToken;
    private final List<String> statuses;
    private final Integer maxResults;

    private ListApplicationsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.statuses = builder.statuses;
        this.maxResults = builder.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final List<ApplicationStatus> statuses() {
        return ApplicationStatusesCopier.copyStringToEnum(this.statuses);
    }

    public final boolean hasStatuses() {
        return this.statuses != null && !(this.statuses instanceof SdkAutoConstructList);
    }

    public final List<String> statusesAsStrings() {
        return this.statuses;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatuses() ? this.statusesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationsRequest)) {
            return false;
        }
        ListApplicationsRequest other = (ListApplicationsRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasStatuses() == other.hasStatuses() && Objects.equals(this.statusesAsStrings(), other.statusesAsStrings()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListApplicationsRequest").add("NextToken", (Object)this.nextToken()).add("Statuses", this.hasStatuses() ? this.statusesAsStrings() : null).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "statuses": {
                return Optional.ofNullable(clazz.cast(this.statusesAsStrings()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationsRequest, T> g) {
        return obj -> g.apply((ListApplicationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<String> statuses = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationsRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.statusesWithStrings(model.statuses);
            this.maxResults(model.maxResults);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getStatuses() {
            if (this.statuses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statuses;
        }

        public final void setStatuses(Collection<String> statuses) {
            this.statuses = ApplicationStatusesCopier.copy(statuses);
        }

        @Override
        public final Builder statusesWithStrings(Collection<String> statuses) {
            this.statuses = ApplicationStatusesCopier.copy(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusesWithStrings(String ... statuses) {
            this.statusesWithStrings(Arrays.asList(statuses));
            return this;
        }

        @Override
        public final Builder statuses(Collection<ApplicationStatus> statuses) {
            this.statuses = ApplicationStatusesCopier.copyEnumToString(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(ApplicationStatus ... statuses) {
            this.statuses(Arrays.asList(statuses));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListApplicationsRequest build() {
            return new ListApplicationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OpenSearchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListApplicationsRequest> {
        public Builder nextToken(String var1);

        public Builder statusesWithStrings(Collection<String> var1);

        public Builder statusesWithStrings(String ... var1);

        public Builder statuses(Collection<ApplicationStatus> var1);

        public Builder statuses(ApplicationStatus ... var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

