/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.VpcEndpointStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpcEndpointSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpcEndpointSummary> {
    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcEndpointId").getter(VpcEndpointSummary.getter(VpcEndpointSummary::vpcEndpointId)).setter(VpcEndpointSummary.setter(Builder::vpcEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId").build()}).build();
    private static final SdkField<String> VPC_ENDPOINT_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcEndpointOwner").getter(VpcEndpointSummary.getter(VpcEndpointSummary::vpcEndpointOwner)).setter(VpcEndpointSummary.setter(Builder::vpcEndpointOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointOwner").build()}).build();
    private static final SdkField<String> DOMAIN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainArn").getter(VpcEndpointSummary.getter(VpcEndpointSummary::domainArn)).setter(VpcEndpointSummary.setter(Builder::domainArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(VpcEndpointSummary.getter(VpcEndpointSummary::statusAsString)).setter(VpcEndpointSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ENDPOINT_ID_FIELD, VPC_ENDPOINT_OWNER_FIELD, DOMAIN_ARN_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("VpcEndpointId", VPC_ENDPOINT_ID_FIELD);
            this.put("VpcEndpointOwner", VPC_ENDPOINT_OWNER_FIELD);
            this.put("DomainArn", DOMAIN_ARN_FIELD);
            this.put("Status", STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String vpcEndpointId;
    private final String vpcEndpointOwner;
    private final String domainArn;
    private final String status;

    private VpcEndpointSummary(BuilderImpl builder) {
        this.vpcEndpointId = builder.vpcEndpointId;
        this.vpcEndpointOwner = builder.vpcEndpointOwner;
        this.domainArn = builder.domainArn;
        this.status = builder.status;
    }

    public final String vpcEndpointId() {
        return this.vpcEndpointId;
    }

    public final String vpcEndpointOwner() {
        return this.vpcEndpointOwner;
    }

    public final String domainArn() {
        return this.domainArn;
    }

    public final VpcEndpointStatus status() {
        return VpcEndpointStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcEndpointSummary)) {
            return false;
        }
        VpcEndpointSummary other = (VpcEndpointSummary)obj;
        return Objects.equals(this.vpcEndpointId(), other.vpcEndpointId()) && Objects.equals(this.vpcEndpointOwner(), other.vpcEndpointOwner()) && Objects.equals(this.domainArn(), other.domainArn()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"VpcEndpointSummary").add("VpcEndpointId", (Object)this.vpcEndpointId()).add("VpcEndpointOwner", (Object)this.vpcEndpointOwner()).add("DomainArn", (Object)this.domainArn()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcEndpointId": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointId()));
            }
            case "VpcEndpointOwner": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointOwner()));
            }
            case "DomainArn": {
                return Optional.ofNullable(clazz.cast(this.domainArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VpcEndpointSummary, T> g) {
        return obj -> g.apply((VpcEndpointSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String vpcEndpointId;
        private String vpcEndpointOwner;
        private String domainArn;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcEndpointSummary model) {
            this.vpcEndpointId(model.vpcEndpointId);
            this.vpcEndpointOwner(model.vpcEndpointOwner);
            this.domainArn(model.domainArn);
            this.status(model.status);
        }

        public final String getVpcEndpointId() {
            return this.vpcEndpointId;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final String getVpcEndpointOwner() {
            return this.vpcEndpointOwner;
        }

        public final void setVpcEndpointOwner(String vpcEndpointOwner) {
            this.vpcEndpointOwner = vpcEndpointOwner;
        }

        @Override
        public final Builder vpcEndpointOwner(String vpcEndpointOwner) {
            this.vpcEndpointOwner = vpcEndpointOwner;
            return this;
        }

        public final String getDomainArn() {
            return this.domainArn;
        }

        public final void setDomainArn(String domainArn) {
            this.domainArn = domainArn;
        }

        @Override
        public final Builder domainArn(String domainArn) {
            this.domainArn = domainArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(VpcEndpointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public VpcEndpointSummary build() {
            return new VpcEndpointSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpcEndpointSummary> {
        public Builder vpcEndpointId(String var1);

        public Builder vpcEndpointOwner(String var1);

        public Builder domainArn(String var1);

        public Builder status(String var1);

        public Builder status(VpcEndpointStatus var1);
    }
}

