/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opensearch.OpenSearchClient;
import software.amazon.awssdk.services.opensearch.internal.UserAgentUtils;
import software.amazon.awssdk.services.opensearch.model.ListPackagesForDomainRequest;
import software.amazon.awssdk.services.opensearch.model.ListPackagesForDomainResponse;

public class ListPackagesForDomainIterable
implements SdkIterable<ListPackagesForDomainResponse> {
    private final OpenSearchClient client;
    private final ListPackagesForDomainRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPackagesForDomainIterable(OpenSearchClient client, ListPackagesForDomainRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPackagesForDomainResponseFetcher();
    }

    public Iterator<ListPackagesForDomainResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListPackagesForDomainResponseFetcher
    implements SyncPageFetcher<ListPackagesForDomainResponse> {
        private ListPackagesForDomainResponseFetcher() {
        }

        public boolean hasNextPage(ListPackagesForDomainResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPackagesForDomainResponse nextPage(ListPackagesForDomainResponse previousPage) {
            if (previousPage == null) {
                return ListPackagesForDomainIterable.this.client.listPackagesForDomain(ListPackagesForDomainIterable.this.firstRequest);
            }
            return ListPackagesForDomainIterable.this.client.listPackagesForDomain((ListPackagesForDomainRequest)((Object)ListPackagesForDomainIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

