/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NodeStatus {
    ACTIVE("Active"),
    STAND_BY("StandBy"),
    NOT_AVAILABLE("NotAvailable"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NodeStatus> VALUE_MAP;
    private final String value;

    private NodeStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NodeStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NodeStatus> knownValues() {
        EnumSet<NodeStatus> knownValues = EnumSet.allOf(NodeStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NodeStatus.class, NodeStatus::toString);
    }
}

