/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opensearch.OpenSearchClient;
import software.amazon.awssdk.services.opensearch.internal.UserAgentUtils;
import software.amazon.awssdk.services.opensearch.model.DescribeInboundConnectionsRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeInboundConnectionsResponse;

public class DescribeInboundConnectionsIterable
implements SdkIterable<DescribeInboundConnectionsResponse> {
    private final OpenSearchClient client;
    private final DescribeInboundConnectionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeInboundConnectionsIterable(OpenSearchClient client, DescribeInboundConnectionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeInboundConnectionsResponseFetcher();
    }

    public Iterator<DescribeInboundConnectionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeInboundConnectionsResponseFetcher
    implements SyncPageFetcher<DescribeInboundConnectionsResponse> {
        private DescribeInboundConnectionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInboundConnectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeInboundConnectionsResponse nextPage(DescribeInboundConnectionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeInboundConnectionsIterable.this.client.describeInboundConnections(DescribeInboundConnectionsIterable.this.firstRequest);
            }
            return DescribeInboundConnectionsIterable.this.client.describeInboundConnections((DescribeInboundConnectionsRequest)((Object)DescribeInboundConnectionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

