/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opensearch.model.OpenSearchException;
import software.amazon.awssdk.services.opensearch.model.SlotListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SlotNotAvailableException
extends OpenSearchException
implements ToCopyableBuilder<Builder, SlotNotAvailableException> {
    private static final SdkField<List<Long>> SLOT_SUGGESTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SlotSuggestions").getter(SlotNotAvailableException.getter(SlotNotAvailableException::slotSuggestions)).setter(SlotNotAvailableException.setter(Builder::slotSuggestions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlotSuggestions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LONG).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLOT_SUGGESTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<Long> slotSuggestions;

    private SlotNotAvailableException(BuilderImpl builder) {
        super(builder);
        this.slotSuggestions = builder.slotSuggestions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public boolean hasSlotSuggestions() {
        return this.slotSuggestions != null && !(this.slotSuggestions instanceof SdkAutoConstructList);
    }

    public List<Long> slotSuggestions() {
        return this.slotSuggestions;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SlotNotAvailableException, T> g) {
        return obj -> g.apply((SlotNotAvailableException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchException.BuilderImpl
    implements Builder {
        private List<Long> slotSuggestions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SlotNotAvailableException model) {
            super(model);
            this.slotSuggestions(model.slotSuggestions);
        }

        public final Collection<Long> getSlotSuggestions() {
            if (this.slotSuggestions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.slotSuggestions;
        }

        public final void setSlotSuggestions(Collection<Long> slotSuggestions) {
            this.slotSuggestions = SlotListCopier.copy(slotSuggestions);
        }

        @Override
        public final Builder slotSuggestions(Collection<Long> slotSuggestions) {
            this.slotSuggestions = SlotListCopier.copy(slotSuggestions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotSuggestions(Long ... slotSuggestions) {
            this.slotSuggestions(Arrays.asList(slotSuggestions));
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public SlotNotAvailableException build() {
            return new SlotNotAvailableException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SlotNotAvailableException>,
    OpenSearchException.Builder {
        public Builder slotSuggestions(Collection<Long> var1);

        public Builder slotSuggestions(Long ... var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);

        @Override
        public Builder writableStackTrace(Boolean var1);
    }
}

