/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.AccessPoliciesStatus;
import software.amazon.awssdk.services.opensearch.model.AdvancedOptionsStatus;
import software.amazon.awssdk.services.opensearch.model.AdvancedSecurityOptionsStatus;
import software.amazon.awssdk.services.opensearch.model.AutoTuneOptionsStatus;
import software.amazon.awssdk.services.opensearch.model.ChangeProgressDetails;
import software.amazon.awssdk.services.opensearch.model.ClusterConfigStatus;
import software.amazon.awssdk.services.opensearch.model.CognitoOptionsStatus;
import software.amazon.awssdk.services.opensearch.model.DomainEndpointOptionsStatus;
import software.amazon.awssdk.services.opensearch.model.EBSOptionsStatus;
import software.amazon.awssdk.services.opensearch.model.EncryptionAtRestOptionsStatus;
import software.amazon.awssdk.services.opensearch.model.IPAddressTypeStatus;
import software.amazon.awssdk.services.opensearch.model.LogPublishingOptionsStatus;
import software.amazon.awssdk.services.opensearch.model.NodeToNodeEncryptionOptionsStatus;
import software.amazon.awssdk.services.opensearch.model.OffPeakWindowOptionsStatus;
import software.amazon.awssdk.services.opensearch.model.SnapshotOptionsStatus;
import software.amazon.awssdk.services.opensearch.model.SoftwareUpdateOptionsStatus;
import software.amazon.awssdk.services.opensearch.model.VPCDerivedInfoStatus;
import software.amazon.awssdk.services.opensearch.model.VersionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DomainConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DomainConfig> {
    private static final SdkField<VersionStatus> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EngineVersion").getter(DomainConfig.getter(DomainConfig::engineVersion)).setter(DomainConfig.setter(Builder::engineVersion)).constructor(VersionStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<ClusterConfigStatus> CLUSTER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ClusterConfig").getter(DomainConfig.getter(DomainConfig::clusterConfig)).setter(DomainConfig.setter(Builder::clusterConfig)).constructor(ClusterConfigStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterConfig").build()}).build();
    private static final SdkField<EBSOptionsStatus> EBS_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EBSOptions").getter(DomainConfig.getter(DomainConfig::ebsOptions)).setter(DomainConfig.setter(Builder::ebsOptions)).constructor(EBSOptionsStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EBSOptions").build()}).build();
    private static final SdkField<AccessPoliciesStatus> ACCESS_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccessPolicies").getter(DomainConfig.getter(DomainConfig::accessPolicies)).setter(DomainConfig.setter(Builder::accessPolicies)).constructor(AccessPoliciesStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPolicies").build()}).build();
    private static final SdkField<IPAddressTypeStatus> IP_ADDRESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IPAddressType").getter(DomainConfig.getter(DomainConfig::ipAddressType)).setter(DomainConfig.setter(Builder::ipAddressType)).constructor(IPAddressTypeStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPAddressType").build()}).build();
    private static final SdkField<SnapshotOptionsStatus> SNAPSHOT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SnapshotOptions").getter(DomainConfig.getter(DomainConfig::snapshotOptions)).setter(DomainConfig.setter(Builder::snapshotOptions)).constructor(SnapshotOptionsStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotOptions").build()}).build();
    private static final SdkField<VPCDerivedInfoStatus> VPC_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VPCOptions").getter(DomainConfig.getter(DomainConfig::vpcOptions)).setter(DomainConfig.setter(Builder::vpcOptions)).constructor(VPCDerivedInfoStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCOptions").build()}).build();
    private static final SdkField<CognitoOptionsStatus> COGNITO_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CognitoOptions").getter(DomainConfig.getter(DomainConfig::cognitoOptions)).setter(DomainConfig.setter(Builder::cognitoOptions)).constructor(CognitoOptionsStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CognitoOptions").build()}).build();
    private static final SdkField<EncryptionAtRestOptionsStatus> ENCRYPTION_AT_REST_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionAtRestOptions").getter(DomainConfig.getter(DomainConfig::encryptionAtRestOptions)).setter(DomainConfig.setter(Builder::encryptionAtRestOptions)).constructor(EncryptionAtRestOptionsStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionAtRestOptions").build()}).build();
    private static final SdkField<NodeToNodeEncryptionOptionsStatus> NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NodeToNodeEncryptionOptions").getter(DomainConfig.getter(DomainConfig::nodeToNodeEncryptionOptions)).setter(DomainConfig.setter(Builder::nodeToNodeEncryptionOptions)).constructor(NodeToNodeEncryptionOptionsStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeToNodeEncryptionOptions").build()}).build();
    private static final SdkField<AdvancedOptionsStatus> ADVANCED_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdvancedOptions").getter(DomainConfig.getter(DomainConfig::advancedOptions)).setter(DomainConfig.setter(Builder::advancedOptions)).constructor(AdvancedOptionsStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedOptions").build()}).build();
    private static final SdkField<LogPublishingOptionsStatus> LOG_PUBLISHING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LogPublishingOptions").getter(DomainConfig.getter(DomainConfig::logPublishingOptions)).setter(DomainConfig.setter(Builder::logPublishingOptions)).constructor(LogPublishingOptionsStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPublishingOptions").build()}).build();
    private static final SdkField<DomainEndpointOptionsStatus> DOMAIN_ENDPOINT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DomainEndpointOptions").getter(DomainConfig.getter(DomainConfig::domainEndpointOptions)).setter(DomainConfig.setter(Builder::domainEndpointOptions)).constructor(DomainEndpointOptionsStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainEndpointOptions").build()}).build();
    private static final SdkField<AdvancedSecurityOptionsStatus> ADVANCED_SECURITY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdvancedSecurityOptions").getter(DomainConfig.getter(DomainConfig::advancedSecurityOptions)).setter(DomainConfig.setter(Builder::advancedSecurityOptions)).constructor(AdvancedSecurityOptionsStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedSecurityOptions").build()}).build();
    private static final SdkField<AutoTuneOptionsStatus> AUTO_TUNE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoTuneOptions").getter(DomainConfig.getter(DomainConfig::autoTuneOptions)).setter(DomainConfig.setter(Builder::autoTuneOptions)).constructor(AutoTuneOptionsStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoTuneOptions").build()}).build();
    private static final SdkField<ChangeProgressDetails> CHANGE_PROGRESS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ChangeProgressDetails").getter(DomainConfig.getter(DomainConfig::changeProgressDetails)).setter(DomainConfig.setter(Builder::changeProgressDetails)).constructor(ChangeProgressDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeProgressDetails").build()}).build();
    private static final SdkField<OffPeakWindowOptionsStatus> OFF_PEAK_WINDOW_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OffPeakWindowOptions").getter(DomainConfig.getter(DomainConfig::offPeakWindowOptions)).setter(DomainConfig.setter(Builder::offPeakWindowOptions)).constructor(OffPeakWindowOptionsStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OffPeakWindowOptions").build()}).build();
    private static final SdkField<SoftwareUpdateOptionsStatus> SOFTWARE_UPDATE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SoftwareUpdateOptions").getter(DomainConfig.getter(DomainConfig::softwareUpdateOptions)).setter(DomainConfig.setter(Builder::softwareUpdateOptions)).constructor(SoftwareUpdateOptionsStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SoftwareUpdateOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_VERSION_FIELD, CLUSTER_CONFIG_FIELD, EBS_OPTIONS_FIELD, ACCESS_POLICIES_FIELD, IP_ADDRESS_TYPE_FIELD, SNAPSHOT_OPTIONS_FIELD, VPC_OPTIONS_FIELD, COGNITO_OPTIONS_FIELD, ENCRYPTION_AT_REST_OPTIONS_FIELD, NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD, ADVANCED_OPTIONS_FIELD, LOG_PUBLISHING_OPTIONS_FIELD, DOMAIN_ENDPOINT_OPTIONS_FIELD, ADVANCED_SECURITY_OPTIONS_FIELD, AUTO_TUNE_OPTIONS_FIELD, CHANGE_PROGRESS_DETAILS_FIELD, OFF_PEAK_WINDOW_OPTIONS_FIELD, SOFTWARE_UPDATE_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final VersionStatus engineVersion;
    private final ClusterConfigStatus clusterConfig;
    private final EBSOptionsStatus ebsOptions;
    private final AccessPoliciesStatus accessPolicies;
    private final IPAddressTypeStatus ipAddressType;
    private final SnapshotOptionsStatus snapshotOptions;
    private final VPCDerivedInfoStatus vpcOptions;
    private final CognitoOptionsStatus cognitoOptions;
    private final EncryptionAtRestOptionsStatus encryptionAtRestOptions;
    private final NodeToNodeEncryptionOptionsStatus nodeToNodeEncryptionOptions;
    private final AdvancedOptionsStatus advancedOptions;
    private final LogPublishingOptionsStatus logPublishingOptions;
    private final DomainEndpointOptionsStatus domainEndpointOptions;
    private final AdvancedSecurityOptionsStatus advancedSecurityOptions;
    private final AutoTuneOptionsStatus autoTuneOptions;
    private final ChangeProgressDetails changeProgressDetails;
    private final OffPeakWindowOptionsStatus offPeakWindowOptions;
    private final SoftwareUpdateOptionsStatus softwareUpdateOptions;

    private DomainConfig(BuilderImpl builder) {
        this.engineVersion = builder.engineVersion;
        this.clusterConfig = builder.clusterConfig;
        this.ebsOptions = builder.ebsOptions;
        this.accessPolicies = builder.accessPolicies;
        this.ipAddressType = builder.ipAddressType;
        this.snapshotOptions = builder.snapshotOptions;
        this.vpcOptions = builder.vpcOptions;
        this.cognitoOptions = builder.cognitoOptions;
        this.encryptionAtRestOptions = builder.encryptionAtRestOptions;
        this.nodeToNodeEncryptionOptions = builder.nodeToNodeEncryptionOptions;
        this.advancedOptions = builder.advancedOptions;
        this.logPublishingOptions = builder.logPublishingOptions;
        this.domainEndpointOptions = builder.domainEndpointOptions;
        this.advancedSecurityOptions = builder.advancedSecurityOptions;
        this.autoTuneOptions = builder.autoTuneOptions;
        this.changeProgressDetails = builder.changeProgressDetails;
        this.offPeakWindowOptions = builder.offPeakWindowOptions;
        this.softwareUpdateOptions = builder.softwareUpdateOptions;
    }

    public final VersionStatus engineVersion() {
        return this.engineVersion;
    }

    public final ClusterConfigStatus clusterConfig() {
        return this.clusterConfig;
    }

    public final EBSOptionsStatus ebsOptions() {
        return this.ebsOptions;
    }

    public final AccessPoliciesStatus accessPolicies() {
        return this.accessPolicies;
    }

    public final IPAddressTypeStatus ipAddressType() {
        return this.ipAddressType;
    }

    public final SnapshotOptionsStatus snapshotOptions() {
        return this.snapshotOptions;
    }

    public final VPCDerivedInfoStatus vpcOptions() {
        return this.vpcOptions;
    }

    public final CognitoOptionsStatus cognitoOptions() {
        return this.cognitoOptions;
    }

    public final EncryptionAtRestOptionsStatus encryptionAtRestOptions() {
        return this.encryptionAtRestOptions;
    }

    public final NodeToNodeEncryptionOptionsStatus nodeToNodeEncryptionOptions() {
        return this.nodeToNodeEncryptionOptions;
    }

    public final AdvancedOptionsStatus advancedOptions() {
        return this.advancedOptions;
    }

    public final LogPublishingOptionsStatus logPublishingOptions() {
        return this.logPublishingOptions;
    }

    public final DomainEndpointOptionsStatus domainEndpointOptions() {
        return this.domainEndpointOptions;
    }

    public final AdvancedSecurityOptionsStatus advancedSecurityOptions() {
        return this.advancedSecurityOptions;
    }

    public final AutoTuneOptionsStatus autoTuneOptions() {
        return this.autoTuneOptions;
    }

    public final ChangeProgressDetails changeProgressDetails() {
        return this.changeProgressDetails;
    }

    public final OffPeakWindowOptionsStatus offPeakWindowOptions() {
        return this.offPeakWindowOptions;
    }

    public final SoftwareUpdateOptionsStatus softwareUpdateOptions() {
        return this.softwareUpdateOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressType());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.cognitoOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionAtRestOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeToNodeEncryptionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.advancedOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.logPublishingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainEndpointOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.advancedSecurityOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoTuneOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeProgressDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.offPeakWindowOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.softwareUpdateOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainConfig)) {
            return false;
        }
        DomainConfig other = (DomainConfig)obj;
        return Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.clusterConfig(), other.clusterConfig()) && Objects.equals(this.ebsOptions(), other.ebsOptions()) && Objects.equals(this.accessPolicies(), other.accessPolicies()) && Objects.equals(this.ipAddressType(), other.ipAddressType()) && Objects.equals(this.snapshotOptions(), other.snapshotOptions()) && Objects.equals(this.vpcOptions(), other.vpcOptions()) && Objects.equals(this.cognitoOptions(), other.cognitoOptions()) && Objects.equals(this.encryptionAtRestOptions(), other.encryptionAtRestOptions()) && Objects.equals(this.nodeToNodeEncryptionOptions(), other.nodeToNodeEncryptionOptions()) && Objects.equals(this.advancedOptions(), other.advancedOptions()) && Objects.equals(this.logPublishingOptions(), other.logPublishingOptions()) && Objects.equals(this.domainEndpointOptions(), other.domainEndpointOptions()) && Objects.equals(this.advancedSecurityOptions(), other.advancedSecurityOptions()) && Objects.equals(this.autoTuneOptions(), other.autoTuneOptions()) && Objects.equals(this.changeProgressDetails(), other.changeProgressDetails()) && Objects.equals(this.offPeakWindowOptions(), other.offPeakWindowOptions()) && Objects.equals(this.softwareUpdateOptions(), other.softwareUpdateOptions());
    }

    public final String toString() {
        return ToString.builder((String)"DomainConfig").add("EngineVersion", (Object)this.engineVersion()).add("ClusterConfig", (Object)this.clusterConfig()).add("EBSOptions", (Object)this.ebsOptions()).add("AccessPolicies", (Object)this.accessPolicies()).add("IPAddressType", (Object)this.ipAddressType()).add("SnapshotOptions", (Object)this.snapshotOptions()).add("VPCOptions", (Object)this.vpcOptions()).add("CognitoOptions", (Object)this.cognitoOptions()).add("EncryptionAtRestOptions", (Object)this.encryptionAtRestOptions()).add("NodeToNodeEncryptionOptions", (Object)this.nodeToNodeEncryptionOptions()).add("AdvancedOptions", (Object)this.advancedOptions()).add("LogPublishingOptions", (Object)this.logPublishingOptions()).add("DomainEndpointOptions", (Object)this.domainEndpointOptions()).add("AdvancedSecurityOptions", (Object)this.advancedSecurityOptions()).add("AutoTuneOptions", (Object)this.autoTuneOptions()).add("ChangeProgressDetails", (Object)this.changeProgressDetails()).add("OffPeakWindowOptions", (Object)this.offPeakWindowOptions()).add("SoftwareUpdateOptions", (Object)this.softwareUpdateOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "ClusterConfig": {
                return Optional.ofNullable(clazz.cast(this.clusterConfig()));
            }
            case "EBSOptions": {
                return Optional.ofNullable(clazz.cast(this.ebsOptions()));
            }
            case "AccessPolicies": {
                return Optional.ofNullable(clazz.cast(this.accessPolicies()));
            }
            case "IPAddressType": {
                return Optional.ofNullable(clazz.cast(this.ipAddressType()));
            }
            case "SnapshotOptions": {
                return Optional.ofNullable(clazz.cast(this.snapshotOptions()));
            }
            case "VPCOptions": {
                return Optional.ofNullable(clazz.cast(this.vpcOptions()));
            }
            case "CognitoOptions": {
                return Optional.ofNullable(clazz.cast(this.cognitoOptions()));
            }
            case "EncryptionAtRestOptions": {
                return Optional.ofNullable(clazz.cast(this.encryptionAtRestOptions()));
            }
            case "NodeToNodeEncryptionOptions": {
                return Optional.ofNullable(clazz.cast(this.nodeToNodeEncryptionOptions()));
            }
            case "AdvancedOptions": {
                return Optional.ofNullable(clazz.cast(this.advancedOptions()));
            }
            case "LogPublishingOptions": {
                return Optional.ofNullable(clazz.cast(this.logPublishingOptions()));
            }
            case "DomainEndpointOptions": {
                return Optional.ofNullable(clazz.cast(this.domainEndpointOptions()));
            }
            case "AdvancedSecurityOptions": {
                return Optional.ofNullable(clazz.cast(this.advancedSecurityOptions()));
            }
            case "AutoTuneOptions": {
                return Optional.ofNullable(clazz.cast(this.autoTuneOptions()));
            }
            case "ChangeProgressDetails": {
                return Optional.ofNullable(clazz.cast(this.changeProgressDetails()));
            }
            case "OffPeakWindowOptions": {
                return Optional.ofNullable(clazz.cast(this.offPeakWindowOptions()));
            }
            case "SoftwareUpdateOptions": {
                return Optional.ofNullable(clazz.cast(this.softwareUpdateOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainConfig, T> g) {
        return obj -> g.apply((DomainConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private VersionStatus engineVersion;
        private ClusterConfigStatus clusterConfig;
        private EBSOptionsStatus ebsOptions;
        private AccessPoliciesStatus accessPolicies;
        private IPAddressTypeStatus ipAddressType;
        private SnapshotOptionsStatus snapshotOptions;
        private VPCDerivedInfoStatus vpcOptions;
        private CognitoOptionsStatus cognitoOptions;
        private EncryptionAtRestOptionsStatus encryptionAtRestOptions;
        private NodeToNodeEncryptionOptionsStatus nodeToNodeEncryptionOptions;
        private AdvancedOptionsStatus advancedOptions;
        private LogPublishingOptionsStatus logPublishingOptions;
        private DomainEndpointOptionsStatus domainEndpointOptions;
        private AdvancedSecurityOptionsStatus advancedSecurityOptions;
        private AutoTuneOptionsStatus autoTuneOptions;
        private ChangeProgressDetails changeProgressDetails;
        private OffPeakWindowOptionsStatus offPeakWindowOptions;
        private SoftwareUpdateOptionsStatus softwareUpdateOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainConfig model) {
            this.engineVersion(model.engineVersion);
            this.clusterConfig(model.clusterConfig);
            this.ebsOptions(model.ebsOptions);
            this.accessPolicies(model.accessPolicies);
            this.ipAddressType(model.ipAddressType);
            this.snapshotOptions(model.snapshotOptions);
            this.vpcOptions(model.vpcOptions);
            this.cognitoOptions(model.cognitoOptions);
            this.encryptionAtRestOptions(model.encryptionAtRestOptions);
            this.nodeToNodeEncryptionOptions(model.nodeToNodeEncryptionOptions);
            this.advancedOptions(model.advancedOptions);
            this.logPublishingOptions(model.logPublishingOptions);
            this.domainEndpointOptions(model.domainEndpointOptions);
            this.advancedSecurityOptions(model.advancedSecurityOptions);
            this.autoTuneOptions(model.autoTuneOptions);
            this.changeProgressDetails(model.changeProgressDetails);
            this.offPeakWindowOptions(model.offPeakWindowOptions);
            this.softwareUpdateOptions(model.softwareUpdateOptions);
        }

        public final VersionStatus.Builder getEngineVersion() {
            return this.engineVersion != null ? this.engineVersion.toBuilder() : null;
        }

        public final void setEngineVersion(VersionStatus.BuilderImpl engineVersion) {
            this.engineVersion = engineVersion != null ? engineVersion.build() : null;
        }

        @Override
        public final Builder engineVersion(VersionStatus engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final ClusterConfigStatus.Builder getClusterConfig() {
            return this.clusterConfig != null ? this.clusterConfig.toBuilder() : null;
        }

        public final void setClusterConfig(ClusterConfigStatus.BuilderImpl clusterConfig) {
            this.clusterConfig = clusterConfig != null ? clusterConfig.build() : null;
        }

        @Override
        public final Builder clusterConfig(ClusterConfigStatus clusterConfig) {
            this.clusterConfig = clusterConfig;
            return this;
        }

        public final EBSOptionsStatus.Builder getEbsOptions() {
            return this.ebsOptions != null ? this.ebsOptions.toBuilder() : null;
        }

        public final void setEbsOptions(EBSOptionsStatus.BuilderImpl ebsOptions) {
            this.ebsOptions = ebsOptions != null ? ebsOptions.build() : null;
        }

        @Override
        public final Builder ebsOptions(EBSOptionsStatus ebsOptions) {
            this.ebsOptions = ebsOptions;
            return this;
        }

        public final AccessPoliciesStatus.Builder getAccessPolicies() {
            return this.accessPolicies != null ? this.accessPolicies.toBuilder() : null;
        }

        public final void setAccessPolicies(AccessPoliciesStatus.BuilderImpl accessPolicies) {
            this.accessPolicies = accessPolicies != null ? accessPolicies.build() : null;
        }

        @Override
        public final Builder accessPolicies(AccessPoliciesStatus accessPolicies) {
            this.accessPolicies = accessPolicies;
            return this;
        }

        public final IPAddressTypeStatus.Builder getIpAddressType() {
            return this.ipAddressType != null ? this.ipAddressType.toBuilder() : null;
        }

        public final void setIpAddressType(IPAddressTypeStatus.BuilderImpl ipAddressType) {
            this.ipAddressType = ipAddressType != null ? ipAddressType.build() : null;
        }

        @Override
        public final Builder ipAddressType(IPAddressTypeStatus ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        public final SnapshotOptionsStatus.Builder getSnapshotOptions() {
            return this.snapshotOptions != null ? this.snapshotOptions.toBuilder() : null;
        }

        public final void setSnapshotOptions(SnapshotOptionsStatus.BuilderImpl snapshotOptions) {
            this.snapshotOptions = snapshotOptions != null ? snapshotOptions.build() : null;
        }

        @Override
        public final Builder snapshotOptions(SnapshotOptionsStatus snapshotOptions) {
            this.snapshotOptions = snapshotOptions;
            return this;
        }

        public final VPCDerivedInfoStatus.Builder getVpcOptions() {
            return this.vpcOptions != null ? this.vpcOptions.toBuilder() : null;
        }

        public final void setVpcOptions(VPCDerivedInfoStatus.BuilderImpl vpcOptions) {
            this.vpcOptions = vpcOptions != null ? vpcOptions.build() : null;
        }

        @Override
        public final Builder vpcOptions(VPCDerivedInfoStatus vpcOptions) {
            this.vpcOptions = vpcOptions;
            return this;
        }

        public final CognitoOptionsStatus.Builder getCognitoOptions() {
            return this.cognitoOptions != null ? this.cognitoOptions.toBuilder() : null;
        }

        public final void setCognitoOptions(CognitoOptionsStatus.BuilderImpl cognitoOptions) {
            this.cognitoOptions = cognitoOptions != null ? cognitoOptions.build() : null;
        }

        @Override
        public final Builder cognitoOptions(CognitoOptionsStatus cognitoOptions) {
            this.cognitoOptions = cognitoOptions;
            return this;
        }

        public final EncryptionAtRestOptionsStatus.Builder getEncryptionAtRestOptions() {
            return this.encryptionAtRestOptions != null ? this.encryptionAtRestOptions.toBuilder() : null;
        }

        public final void setEncryptionAtRestOptions(EncryptionAtRestOptionsStatus.BuilderImpl encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions != null ? encryptionAtRestOptions.build() : null;
        }

        @Override
        public final Builder encryptionAtRestOptions(EncryptionAtRestOptionsStatus encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions;
            return this;
        }

        public final NodeToNodeEncryptionOptionsStatus.Builder getNodeToNodeEncryptionOptions() {
            return this.nodeToNodeEncryptionOptions != null ? this.nodeToNodeEncryptionOptions.toBuilder() : null;
        }

        public final void setNodeToNodeEncryptionOptions(NodeToNodeEncryptionOptionsStatus.BuilderImpl nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions != null ? nodeToNodeEncryptionOptions.build() : null;
        }

        @Override
        public final Builder nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptionsStatus nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions;
            return this;
        }

        public final AdvancedOptionsStatus.Builder getAdvancedOptions() {
            return this.advancedOptions != null ? this.advancedOptions.toBuilder() : null;
        }

        public final void setAdvancedOptions(AdvancedOptionsStatus.BuilderImpl advancedOptions) {
            this.advancedOptions = advancedOptions != null ? advancedOptions.build() : null;
        }

        @Override
        public final Builder advancedOptions(AdvancedOptionsStatus advancedOptions) {
            this.advancedOptions = advancedOptions;
            return this;
        }

        public final LogPublishingOptionsStatus.Builder getLogPublishingOptions() {
            return this.logPublishingOptions != null ? this.logPublishingOptions.toBuilder() : null;
        }

        public final void setLogPublishingOptions(LogPublishingOptionsStatus.BuilderImpl logPublishingOptions) {
            this.logPublishingOptions = logPublishingOptions != null ? logPublishingOptions.build() : null;
        }

        @Override
        public final Builder logPublishingOptions(LogPublishingOptionsStatus logPublishingOptions) {
            this.logPublishingOptions = logPublishingOptions;
            return this;
        }

        public final DomainEndpointOptionsStatus.Builder getDomainEndpointOptions() {
            return this.domainEndpointOptions != null ? this.domainEndpointOptions.toBuilder() : null;
        }

        public final void setDomainEndpointOptions(DomainEndpointOptionsStatus.BuilderImpl domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions != null ? domainEndpointOptions.build() : null;
        }

        @Override
        public final Builder domainEndpointOptions(DomainEndpointOptionsStatus domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions;
            return this;
        }

        public final AdvancedSecurityOptionsStatus.Builder getAdvancedSecurityOptions() {
            return this.advancedSecurityOptions != null ? this.advancedSecurityOptions.toBuilder() : null;
        }

        public final void setAdvancedSecurityOptions(AdvancedSecurityOptionsStatus.BuilderImpl advancedSecurityOptions) {
            this.advancedSecurityOptions = advancedSecurityOptions != null ? advancedSecurityOptions.build() : null;
        }

        @Override
        public final Builder advancedSecurityOptions(AdvancedSecurityOptionsStatus advancedSecurityOptions) {
            this.advancedSecurityOptions = advancedSecurityOptions;
            return this;
        }

        public final AutoTuneOptionsStatus.Builder getAutoTuneOptions() {
            return this.autoTuneOptions != null ? this.autoTuneOptions.toBuilder() : null;
        }

        public final void setAutoTuneOptions(AutoTuneOptionsStatus.BuilderImpl autoTuneOptions) {
            this.autoTuneOptions = autoTuneOptions != null ? autoTuneOptions.build() : null;
        }

        @Override
        public final Builder autoTuneOptions(AutoTuneOptionsStatus autoTuneOptions) {
            this.autoTuneOptions = autoTuneOptions;
            return this;
        }

        public final ChangeProgressDetails.Builder getChangeProgressDetails() {
            return this.changeProgressDetails != null ? this.changeProgressDetails.toBuilder() : null;
        }

        public final void setChangeProgressDetails(ChangeProgressDetails.BuilderImpl changeProgressDetails) {
            this.changeProgressDetails = changeProgressDetails != null ? changeProgressDetails.build() : null;
        }

        @Override
        public final Builder changeProgressDetails(ChangeProgressDetails changeProgressDetails) {
            this.changeProgressDetails = changeProgressDetails;
            return this;
        }

        public final OffPeakWindowOptionsStatus.Builder getOffPeakWindowOptions() {
            return this.offPeakWindowOptions != null ? this.offPeakWindowOptions.toBuilder() : null;
        }

        public final void setOffPeakWindowOptions(OffPeakWindowOptionsStatus.BuilderImpl offPeakWindowOptions) {
            this.offPeakWindowOptions = offPeakWindowOptions != null ? offPeakWindowOptions.build() : null;
        }

        @Override
        public final Builder offPeakWindowOptions(OffPeakWindowOptionsStatus offPeakWindowOptions) {
            this.offPeakWindowOptions = offPeakWindowOptions;
            return this;
        }

        public final SoftwareUpdateOptionsStatus.Builder getSoftwareUpdateOptions() {
            return this.softwareUpdateOptions != null ? this.softwareUpdateOptions.toBuilder() : null;
        }

        public final void setSoftwareUpdateOptions(SoftwareUpdateOptionsStatus.BuilderImpl softwareUpdateOptions) {
            this.softwareUpdateOptions = softwareUpdateOptions != null ? softwareUpdateOptions.build() : null;
        }

        @Override
        public final Builder softwareUpdateOptions(SoftwareUpdateOptionsStatus softwareUpdateOptions) {
            this.softwareUpdateOptions = softwareUpdateOptions;
            return this;
        }

        public DomainConfig build() {
            return new DomainConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DomainConfig> {
        public Builder engineVersion(VersionStatus var1);

        default public Builder engineVersion(Consumer<VersionStatus.Builder> engineVersion) {
            return this.engineVersion((VersionStatus)((VersionStatus.Builder)VersionStatus.builder().applyMutation(engineVersion)).build());
        }

        public Builder clusterConfig(ClusterConfigStatus var1);

        default public Builder clusterConfig(Consumer<ClusterConfigStatus.Builder> clusterConfig) {
            return this.clusterConfig((ClusterConfigStatus)((ClusterConfigStatus.Builder)ClusterConfigStatus.builder().applyMutation(clusterConfig)).build());
        }

        public Builder ebsOptions(EBSOptionsStatus var1);

        default public Builder ebsOptions(Consumer<EBSOptionsStatus.Builder> ebsOptions) {
            return this.ebsOptions((EBSOptionsStatus)((EBSOptionsStatus.Builder)EBSOptionsStatus.builder().applyMutation(ebsOptions)).build());
        }

        public Builder accessPolicies(AccessPoliciesStatus var1);

        default public Builder accessPolicies(Consumer<AccessPoliciesStatus.Builder> accessPolicies) {
            return this.accessPolicies((AccessPoliciesStatus)((AccessPoliciesStatus.Builder)AccessPoliciesStatus.builder().applyMutation(accessPolicies)).build());
        }

        public Builder ipAddressType(IPAddressTypeStatus var1);

        default public Builder ipAddressType(Consumer<IPAddressTypeStatus.Builder> ipAddressType) {
            return this.ipAddressType((IPAddressTypeStatus)((IPAddressTypeStatus.Builder)IPAddressTypeStatus.builder().applyMutation(ipAddressType)).build());
        }

        public Builder snapshotOptions(SnapshotOptionsStatus var1);

        default public Builder snapshotOptions(Consumer<SnapshotOptionsStatus.Builder> snapshotOptions) {
            return this.snapshotOptions((SnapshotOptionsStatus)((SnapshotOptionsStatus.Builder)SnapshotOptionsStatus.builder().applyMutation(snapshotOptions)).build());
        }

        public Builder vpcOptions(VPCDerivedInfoStatus var1);

        default public Builder vpcOptions(Consumer<VPCDerivedInfoStatus.Builder> vpcOptions) {
            return this.vpcOptions((VPCDerivedInfoStatus)((VPCDerivedInfoStatus.Builder)VPCDerivedInfoStatus.builder().applyMutation(vpcOptions)).build());
        }

        public Builder cognitoOptions(CognitoOptionsStatus var1);

        default public Builder cognitoOptions(Consumer<CognitoOptionsStatus.Builder> cognitoOptions) {
            return this.cognitoOptions((CognitoOptionsStatus)((CognitoOptionsStatus.Builder)CognitoOptionsStatus.builder().applyMutation(cognitoOptions)).build());
        }

        public Builder encryptionAtRestOptions(EncryptionAtRestOptionsStatus var1);

        default public Builder encryptionAtRestOptions(Consumer<EncryptionAtRestOptionsStatus.Builder> encryptionAtRestOptions) {
            return this.encryptionAtRestOptions((EncryptionAtRestOptionsStatus)((EncryptionAtRestOptionsStatus.Builder)EncryptionAtRestOptionsStatus.builder().applyMutation(encryptionAtRestOptions)).build());
        }

        public Builder nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptionsStatus var1);

        default public Builder nodeToNodeEncryptionOptions(Consumer<NodeToNodeEncryptionOptionsStatus.Builder> nodeToNodeEncryptionOptions) {
            return this.nodeToNodeEncryptionOptions((NodeToNodeEncryptionOptionsStatus)((NodeToNodeEncryptionOptionsStatus.Builder)NodeToNodeEncryptionOptionsStatus.builder().applyMutation(nodeToNodeEncryptionOptions)).build());
        }

        public Builder advancedOptions(AdvancedOptionsStatus var1);

        default public Builder advancedOptions(Consumer<AdvancedOptionsStatus.Builder> advancedOptions) {
            return this.advancedOptions((AdvancedOptionsStatus)((AdvancedOptionsStatus.Builder)AdvancedOptionsStatus.builder().applyMutation(advancedOptions)).build());
        }

        public Builder logPublishingOptions(LogPublishingOptionsStatus var1);

        default public Builder logPublishingOptions(Consumer<LogPublishingOptionsStatus.Builder> logPublishingOptions) {
            return this.logPublishingOptions((LogPublishingOptionsStatus)((LogPublishingOptionsStatus.Builder)LogPublishingOptionsStatus.builder().applyMutation(logPublishingOptions)).build());
        }

        public Builder domainEndpointOptions(DomainEndpointOptionsStatus var1);

        default public Builder domainEndpointOptions(Consumer<DomainEndpointOptionsStatus.Builder> domainEndpointOptions) {
            return this.domainEndpointOptions((DomainEndpointOptionsStatus)((DomainEndpointOptionsStatus.Builder)DomainEndpointOptionsStatus.builder().applyMutation(domainEndpointOptions)).build());
        }

        public Builder advancedSecurityOptions(AdvancedSecurityOptionsStatus var1);

        default public Builder advancedSecurityOptions(Consumer<AdvancedSecurityOptionsStatus.Builder> advancedSecurityOptions) {
            return this.advancedSecurityOptions((AdvancedSecurityOptionsStatus)((AdvancedSecurityOptionsStatus.Builder)AdvancedSecurityOptionsStatus.builder().applyMutation(advancedSecurityOptions)).build());
        }

        public Builder autoTuneOptions(AutoTuneOptionsStatus var1);

        default public Builder autoTuneOptions(Consumer<AutoTuneOptionsStatus.Builder> autoTuneOptions) {
            return this.autoTuneOptions((AutoTuneOptionsStatus)((AutoTuneOptionsStatus.Builder)AutoTuneOptionsStatus.builder().applyMutation(autoTuneOptions)).build());
        }

        public Builder changeProgressDetails(ChangeProgressDetails var1);

        default public Builder changeProgressDetails(Consumer<ChangeProgressDetails.Builder> changeProgressDetails) {
            return this.changeProgressDetails((ChangeProgressDetails)((ChangeProgressDetails.Builder)ChangeProgressDetails.builder().applyMutation(changeProgressDetails)).build());
        }

        public Builder offPeakWindowOptions(OffPeakWindowOptionsStatus var1);

        default public Builder offPeakWindowOptions(Consumer<OffPeakWindowOptionsStatus.Builder> offPeakWindowOptions) {
            return this.offPeakWindowOptions((OffPeakWindowOptionsStatus)((OffPeakWindowOptionsStatus.Builder)OffPeakWindowOptionsStatus.builder().applyMutation(offPeakWindowOptions)).build());
        }

        public Builder softwareUpdateOptions(SoftwareUpdateOptionsStatus var1);

        default public Builder softwareUpdateOptions(Consumer<SoftwareUpdateOptionsStatus.Builder> softwareUpdateOptions) {
            return this.softwareUpdateOptions((SoftwareUpdateOptionsStatus)((SoftwareUpdateOptionsStatus.Builder)SoftwareUpdateOptionsStatus.builder().applyMutation(softwareUpdateOptions)).build());
        }
    }
}

