/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateScheduledActionResponse extends OpenSearchResponse implements
        ToCopyableBuilder<UpdateScheduledActionResponse.Builder, UpdateScheduledActionResponse> {
    private static final SdkField<ScheduledAction> SCHEDULED_ACTION_FIELD = SdkField
            .<ScheduledAction> builder(MarshallingType.SDK_POJO).memberName("ScheduledAction")
            .getter(getter(UpdateScheduledActionResponse::scheduledAction)).setter(setter(Builder::scheduledAction))
            .constructor(ScheduledAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULED_ACTION_FIELD));

    private final ScheduledAction scheduledAction;

    private UpdateScheduledActionResponse(BuilderImpl builder) {
        super(builder);
        this.scheduledAction = builder.scheduledAction;
    }

    /**
     * <p>
     * Information about the rescheduled action.
     * </p>
     * 
     * @return Information about the rescheduled action.
     */
    public final ScheduledAction scheduledAction() {
        return scheduledAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scheduledAction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateScheduledActionResponse)) {
            return false;
        }
        UpdateScheduledActionResponse other = (UpdateScheduledActionResponse) obj;
        return Objects.equals(scheduledAction(), other.scheduledAction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateScheduledActionResponse").add("ScheduledAction", scheduledAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScheduledAction":
            return Optional.ofNullable(clazz.cast(scheduledAction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateScheduledActionResponse, T> g) {
        return obj -> g.apply((UpdateScheduledActionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateScheduledActionResponse> {
        /**
         * <p>
         * Information about the rescheduled action.
         * </p>
         * 
         * @param scheduledAction
         *        Information about the rescheduled action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledAction(ScheduledAction scheduledAction);

        /**
         * <p>
         * Information about the rescheduled action.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScheduledAction.Builder} avoiding the
         * need to create one manually via {@link ScheduledAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScheduledAction.Builder#build()} is called immediately and its
         * result is passed to {@link #scheduledAction(ScheduledAction)}.
         * 
         * @param scheduledAction
         *        a consumer that will call methods on {@link ScheduledAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduledAction(ScheduledAction)
         */
        default Builder scheduledAction(Consumer<ScheduledAction.Builder> scheduledAction) {
            return scheduledAction(ScheduledAction.builder().applyMutation(scheduledAction).build());
        }
    }

    static final class BuilderImpl extends OpenSearchResponse.BuilderImpl implements Builder {
        private ScheduledAction scheduledAction;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateScheduledActionResponse model) {
            super(model);
            scheduledAction(model.scheduledAction);
        }

        public final ScheduledAction.Builder getScheduledAction() {
            return scheduledAction != null ? scheduledAction.toBuilder() : null;
        }

        public final void setScheduledAction(ScheduledAction.BuilderImpl scheduledAction) {
            this.scheduledAction = scheduledAction != null ? scheduledAction.build() : null;
        }

        @Override
        public final Builder scheduledAction(ScheduledAction scheduledAction) {
            this.scheduledAction = scheduledAction;
            return this;
        }

        @Override
        public UpdateScheduledActionResponse build() {
            return new UpdateScheduledActionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
