/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateScheduledActionRequest extends OpenSearchRequest implements
        ToCopyableBuilder<UpdateScheduledActionRequest.Builder, UpdateScheduledActionRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(UpdateScheduledActionRequest::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()).build();

    private static final SdkField<String> ACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionID").getter(getter(UpdateScheduledActionRequest::actionID)).setter(setter(Builder::actionID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionID").build()).build();

    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionType").getter(getter(UpdateScheduledActionRequest::actionTypeAsString))
            .setter(setter(Builder::actionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionType").build()).build();

    private static final SdkField<String> SCHEDULE_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScheduleAt").getter(getter(UpdateScheduledActionRequest::scheduleAtAsString))
            .setter(setter(Builder::scheduleAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleAt").build()).build();

    private static final SdkField<Long> DESIRED_START_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DesiredStartTime").getter(getter(UpdateScheduledActionRequest::desiredStartTime))
            .setter(setter(Builder::desiredStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredStartTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            ACTION_ID_FIELD, ACTION_TYPE_FIELD, SCHEDULE_AT_FIELD, DESIRED_START_TIME_FIELD));

    private final String domainName;

    private final String actionID;

    private final String actionType;

    private final String scheduleAt;

    private final Long desiredStartTime;

    private UpdateScheduledActionRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.actionID = builder.actionID;
        this.actionType = builder.actionType;
        this.scheduleAt = builder.scheduleAt;
        this.desiredStartTime = builder.desiredStartTime;
    }

    /**
     * <p>
     * The name of the domain to reschedule an action for.
     * </p>
     * 
     * @return The name of the domain to reschedule an action for.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The unique identifier of the action to reschedule. To retrieve this ID, send a <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_ListScheduledActions.html"
     * >ListScheduledActions</a> request.
     * </p>
     * 
     * @return The unique identifier of the action to reschedule. To retrieve this ID, send a <a
     *         href="https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_ListScheduledActions.html"
     *         >ListScheduledActions</a> request.
     */
    public final String actionID() {
        return actionID;
    }

    /**
     * <p>
     * The type of action to reschedule. Can be one of <code>SERVICE_SOFTWARE_UPDATE</code>,
     * <code>JVM_HEAP_SIZE_TUNING</code>, or <code>JVM_YOUNG_GEN_TUNING</code>. To retrieve this value, send a <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_ListScheduledActions.html"
     * >ListScheduledActions</a> request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link ActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionTypeAsString}.
     * </p>
     * 
     * @return The type of action to reschedule. Can be one of <code>SERVICE_SOFTWARE_UPDATE</code>,
     *         <code>JVM_HEAP_SIZE_TUNING</code>, or <code>JVM_YOUNG_GEN_TUNING</code>. To retrieve this value, send a
     *         <a
     *         href="https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_ListScheduledActions.html"
     *         >ListScheduledActions</a> request.
     * @see ActionType
     */
    public final ActionType actionType() {
        return ActionType.fromValue(actionType);
    }

    /**
     * <p>
     * The type of action to reschedule. Can be one of <code>SERVICE_SOFTWARE_UPDATE</code>,
     * <code>JVM_HEAP_SIZE_TUNING</code>, or <code>JVM_YOUNG_GEN_TUNING</code>. To retrieve this value, send a <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_ListScheduledActions.html"
     * >ListScheduledActions</a> request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link ActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionTypeAsString}.
     * </p>
     * 
     * @return The type of action to reschedule. Can be one of <code>SERVICE_SOFTWARE_UPDATE</code>,
     *         <code>JVM_HEAP_SIZE_TUNING</code>, or <code>JVM_YOUNG_GEN_TUNING</code>. To retrieve this value, send a
     *         <a
     *         href="https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_ListScheduledActions.html"
     *         >ListScheduledActions</a> request.
     * @see ActionType
     */
    public final String actionTypeAsString() {
        return actionType;
    }

    /**
     * <p>
     * When to schedule the action.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NOW</code> - Immediately schedules the update to happen in the current hour if there's capacity available.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TIMESTAMP</code> - Lets you specify a custom date and time to apply the update. If you specify this value,
     * you must also provide a value for <code>DesiredStartTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OFF_PEAK_WINDOW</code> - Marks the action to be picked up during an upcoming off-peak window. There's no
     * guarantee that the change will be implemented during the next immediate window. Depending on capacity, it might
     * happen in subsequent days.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scheduleAt} will
     * return {@link ScheduleAt#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scheduleAtAsString}.
     * </p>
     * 
     * @return When to schedule the action.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NOW</code> - Immediately schedules the update to happen in the current hour if there's capacity
     *         available.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TIMESTAMP</code> - Lets you specify a custom date and time to apply the update. If you specify this
     *         value, you must also provide a value for <code>DesiredStartTime</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OFF_PEAK_WINDOW</code> - Marks the action to be picked up during an upcoming off-peak window.
     *         There's no guarantee that the change will be implemented during the next immediate window. Depending on
     *         capacity, it might happen in subsequent days.
     *         </p>
     *         </li>
     * @see ScheduleAt
     */
    public final ScheduleAt scheduleAt() {
        return ScheduleAt.fromValue(scheduleAt);
    }

    /**
     * <p>
     * When to schedule the action.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NOW</code> - Immediately schedules the update to happen in the current hour if there's capacity available.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TIMESTAMP</code> - Lets you specify a custom date and time to apply the update. If you specify this value,
     * you must also provide a value for <code>DesiredStartTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OFF_PEAK_WINDOW</code> - Marks the action to be picked up during an upcoming off-peak window. There's no
     * guarantee that the change will be implemented during the next immediate window. Depending on capacity, it might
     * happen in subsequent days.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scheduleAt} will
     * return {@link ScheduleAt#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scheduleAtAsString}.
     * </p>
     * 
     * @return When to schedule the action.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NOW</code> - Immediately schedules the update to happen in the current hour if there's capacity
     *         available.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TIMESTAMP</code> - Lets you specify a custom date and time to apply the update. If you specify this
     *         value, you must also provide a value for <code>DesiredStartTime</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OFF_PEAK_WINDOW</code> - Marks the action to be picked up during an upcoming off-peak window.
     *         There's no guarantee that the change will be implemented during the next immediate window. Depending on
     *         capacity, it might happen in subsequent days.
     *         </p>
     *         </li>
     * @see ScheduleAt
     */
    public final String scheduleAtAsString() {
        return scheduleAt;
    }

    /**
     * <p>
     * The time to implement the change, in Coordinated Universal Time (UTC). Only specify this parameter if you set
     * <code>ScheduleAt</code> to <code>TIMESTAMP</code>.
     * </p>
     * 
     * @return The time to implement the change, in Coordinated Universal Time (UTC). Only specify this parameter if you
     *         set <code>ScheduleAt</code> to <code>TIMESTAMP</code>.
     */
    public final Long desiredStartTime() {
        return desiredStartTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(actionID());
        hashCode = 31 * hashCode + Objects.hashCode(actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleAtAsString());
        hashCode = 31 * hashCode + Objects.hashCode(desiredStartTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateScheduledActionRequest)) {
            return false;
        }
        UpdateScheduledActionRequest other = (UpdateScheduledActionRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(actionID(), other.actionID())
                && Objects.equals(actionTypeAsString(), other.actionTypeAsString())
                && Objects.equals(scheduleAtAsString(), other.scheduleAtAsString())
                && Objects.equals(desiredStartTime(), other.desiredStartTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateScheduledActionRequest").add("DomainName", domainName()).add("ActionID", actionID())
                .add("ActionType", actionTypeAsString()).add("ScheduleAt", scheduleAtAsString())
                .add("DesiredStartTime", desiredStartTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "ActionID":
            return Optional.ofNullable(clazz.cast(actionID()));
        case "ActionType":
            return Optional.ofNullable(clazz.cast(actionTypeAsString()));
        case "ScheduleAt":
            return Optional.ofNullable(clazz.cast(scheduleAtAsString()));
        case "DesiredStartTime":
            return Optional.ofNullable(clazz.cast(desiredStartTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateScheduledActionRequest, T> g) {
        return obj -> g.apply((UpdateScheduledActionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateScheduledActionRequest> {
        /**
         * <p>
         * The name of the domain to reschedule an action for.
         * </p>
         * 
         * @param domainName
         *        The name of the domain to reschedule an action for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The unique identifier of the action to reschedule. To retrieve this ID, send a <a
         * href="https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_ListScheduledActions.html"
         * >ListScheduledActions</a> request.
         * </p>
         * 
         * @param actionID
         *        The unique identifier of the action to reschedule. To retrieve this ID, send a <a href=
         *        "https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_ListScheduledActions.html"
         *        >ListScheduledActions</a> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionID(String actionID);

        /**
         * <p>
         * The type of action to reschedule. Can be one of <code>SERVICE_SOFTWARE_UPDATE</code>,
         * <code>JVM_HEAP_SIZE_TUNING</code>, or <code>JVM_YOUNG_GEN_TUNING</code>. To retrieve this value, send a <a
         * href="https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_ListScheduledActions.html">
         * ListScheduledActions</a> request.
         * </p>
         * 
         * @param actionType
         *        The type of action to reschedule. Can be one of <code>SERVICE_SOFTWARE_UPDATE</code>,
         *        <code>JVM_HEAP_SIZE_TUNING</code>, or <code>JVM_YOUNG_GEN_TUNING</code>. To retrieve this value, send
         *        a <a href=
         *        "https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_ListScheduledActions.html"
         *        >ListScheduledActions</a> request.
         * @see ActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionType
         */
        Builder actionType(String actionType);

        /**
         * <p>
         * The type of action to reschedule. Can be one of <code>SERVICE_SOFTWARE_UPDATE</code>,
         * <code>JVM_HEAP_SIZE_TUNING</code>, or <code>JVM_YOUNG_GEN_TUNING</code>. To retrieve this value, send a <a
         * href="https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_ListScheduledActions.html">
         * ListScheduledActions</a> request.
         * </p>
         * 
         * @param actionType
         *        The type of action to reschedule. Can be one of <code>SERVICE_SOFTWARE_UPDATE</code>,
         *        <code>JVM_HEAP_SIZE_TUNING</code>, or <code>JVM_YOUNG_GEN_TUNING</code>. To retrieve this value, send
         *        a <a href=
         *        "https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_ListScheduledActions.html"
         *        >ListScheduledActions</a> request.
         * @see ActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionType
         */
        Builder actionType(ActionType actionType);

        /**
         * <p>
         * When to schedule the action.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NOW</code> - Immediately schedules the update to happen in the current hour if there's capacity
         * available.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TIMESTAMP</code> - Lets you specify a custom date and time to apply the update. If you specify this
         * value, you must also provide a value for <code>DesiredStartTime</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OFF_PEAK_WINDOW</code> - Marks the action to be picked up during an upcoming off-peak window. There's
         * no guarantee that the change will be implemented during the next immediate window. Depending on capacity, it
         * might happen in subsequent days.
         * </p>
         * </li>
         * </ul>
         * 
         * @param scheduleAt
         *        When to schedule the action.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NOW</code> - Immediately schedules the update to happen in the current hour if there's capacity
         *        available.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TIMESTAMP</code> - Lets you specify a custom date and time to apply the update. If you specify
         *        this value, you must also provide a value for <code>DesiredStartTime</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OFF_PEAK_WINDOW</code> - Marks the action to be picked up during an upcoming off-peak window.
         *        There's no guarantee that the change will be implemented during the next immediate window. Depending
         *        on capacity, it might happen in subsequent days.
         *        </p>
         *        </li>
         * @see ScheduleAt
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduleAt
         */
        Builder scheduleAt(String scheduleAt);

        /**
         * <p>
         * When to schedule the action.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NOW</code> - Immediately schedules the update to happen in the current hour if there's capacity
         * available.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TIMESTAMP</code> - Lets you specify a custom date and time to apply the update. If you specify this
         * value, you must also provide a value for <code>DesiredStartTime</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OFF_PEAK_WINDOW</code> - Marks the action to be picked up during an upcoming off-peak window. There's
         * no guarantee that the change will be implemented during the next immediate window. Depending on capacity, it
         * might happen in subsequent days.
         * </p>
         * </li>
         * </ul>
         * 
         * @param scheduleAt
         *        When to schedule the action.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NOW</code> - Immediately schedules the update to happen in the current hour if there's capacity
         *        available.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TIMESTAMP</code> - Lets you specify a custom date and time to apply the update. If you specify
         *        this value, you must also provide a value for <code>DesiredStartTime</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OFF_PEAK_WINDOW</code> - Marks the action to be picked up during an upcoming off-peak window.
         *        There's no guarantee that the change will be implemented during the next immediate window. Depending
         *        on capacity, it might happen in subsequent days.
         *        </p>
         *        </li>
         * @see ScheduleAt
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduleAt
         */
        Builder scheduleAt(ScheduleAt scheduleAt);

        /**
         * <p>
         * The time to implement the change, in Coordinated Universal Time (UTC). Only specify this parameter if you set
         * <code>ScheduleAt</code> to <code>TIMESTAMP</code>.
         * </p>
         * 
         * @param desiredStartTime
         *        The time to implement the change, in Coordinated Universal Time (UTC). Only specify this parameter if
         *        you set <code>ScheduleAt</code> to <code>TIMESTAMP</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredStartTime(Long desiredStartTime);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpenSearchRequest.BuilderImpl implements Builder {
        private String domainName;

        private String actionID;

        private String actionType;

        private String scheduleAt;

        private Long desiredStartTime;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateScheduledActionRequest model) {
            super(model);
            domainName(model.domainName);
            actionID(model.actionID);
            actionType(model.actionType);
            scheduleAt(model.scheduleAt);
            desiredStartTime(model.desiredStartTime);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getActionID() {
            return actionID;
        }

        public final void setActionID(String actionID) {
            this.actionID = actionID;
        }

        @Override
        public final Builder actionID(String actionID) {
            this.actionID = actionID;
            return this;
        }

        public final String getActionType() {
            return actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(ActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        public final String getScheduleAt() {
            return scheduleAt;
        }

        public final void setScheduleAt(String scheduleAt) {
            this.scheduleAt = scheduleAt;
        }

        @Override
        public final Builder scheduleAt(String scheduleAt) {
            this.scheduleAt = scheduleAt;
            return this;
        }

        @Override
        public final Builder scheduleAt(ScheduleAt scheduleAt) {
            this.scheduleAt(scheduleAt == null ? null : scheduleAt.toString());
            return this;
        }

        public final Long getDesiredStartTime() {
            return desiredStartTime;
        }

        public final void setDesiredStartTime(Long desiredStartTime) {
            this.desiredStartTime = desiredStartTime;
        }

        @Override
        public final Builder desiredStartTime(Long desiredStartTime) {
            this.desiredStartTime = desiredStartTime;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateScheduledActionRequest build() {
            return new UpdateScheduledActionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
