/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Options for configuring service software updates for a domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SoftwareUpdateOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<SoftwareUpdateOptions.Builder, SoftwareUpdateOptions> {
    private static final SdkField<Boolean> AUTO_SOFTWARE_UPDATE_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("AutoSoftwareUpdateEnabled")
            .getter(getter(SoftwareUpdateOptions::autoSoftwareUpdateEnabled)).setter(setter(Builder::autoSoftwareUpdateEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoSoftwareUpdateEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(AUTO_SOFTWARE_UPDATE_ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean autoSoftwareUpdateEnabled;

    private SoftwareUpdateOptions(BuilderImpl builder) {
        this.autoSoftwareUpdateEnabled = builder.autoSoftwareUpdateEnabled;
    }

    /**
     * <p>
     * Whether automatic service software updates are enabled for the domain.
     * </p>
     * 
     * @return Whether automatic service software updates are enabled for the domain.
     */
    public final Boolean autoSoftwareUpdateEnabled() {
        return autoSoftwareUpdateEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoSoftwareUpdateEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SoftwareUpdateOptions)) {
            return false;
        }
        SoftwareUpdateOptions other = (SoftwareUpdateOptions) obj;
        return Objects.equals(autoSoftwareUpdateEnabled(), other.autoSoftwareUpdateEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SoftwareUpdateOptions").add("AutoSoftwareUpdateEnabled", autoSoftwareUpdateEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoSoftwareUpdateEnabled":
            return Optional.ofNullable(clazz.cast(autoSoftwareUpdateEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SoftwareUpdateOptions, T> g) {
        return obj -> g.apply((SoftwareUpdateOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SoftwareUpdateOptions> {
        /**
         * <p>
         * Whether automatic service software updates are enabled for the domain.
         * </p>
         * 
         * @param autoSoftwareUpdateEnabled
         *        Whether automatic service software updates are enabled for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoSoftwareUpdateEnabled(Boolean autoSoftwareUpdateEnabled);
    }

    static final class BuilderImpl implements Builder {
        private Boolean autoSoftwareUpdateEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(SoftwareUpdateOptions model) {
            autoSoftwareUpdateEnabled(model.autoSoftwareUpdateEnabled);
        }

        public final Boolean getAutoSoftwareUpdateEnabled() {
            return autoSoftwareUpdateEnabled;
        }

        public final void setAutoSoftwareUpdateEnabled(Boolean autoSoftwareUpdateEnabled) {
            this.autoSoftwareUpdateEnabled = autoSoftwareUpdateEnabled;
        }

        @Override
        public final Builder autoSoftwareUpdateEnabled(Boolean autoSoftwareUpdateEnabled) {
            this.autoSoftwareUpdateEnabled = autoSoftwareUpdateEnabled;
            return this;
        }

        @Override
        public SoftwareUpdateOptions build() {
            return new SoftwareUpdateOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
