/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for request parameters to the <code>PurchaseReservedInstanceOffering</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PurchaseReservedInstanceOfferingRequest extends OpenSearchRequest implements
        ToCopyableBuilder<PurchaseReservedInstanceOfferingRequest.Builder, PurchaseReservedInstanceOfferingRequest> {
    private static final SdkField<String> RESERVED_INSTANCE_OFFERING_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReservedInstanceOfferingId")
            .getter(getter(PurchaseReservedInstanceOfferingRequest::reservedInstanceOfferingId))
            .setter(setter(Builder::reservedInstanceOfferingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstanceOfferingId").build())
            .build();

    private static final SdkField<String> RESERVATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReservationName").getter(getter(PurchaseReservedInstanceOfferingRequest::reservationName))
            .setter(setter(Builder::reservationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservationName").build()).build();

    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstanceCount").getter(getter(PurchaseReservedInstanceOfferingRequest::instanceCount))
            .setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RESERVED_INSTANCE_OFFERING_ID_FIELD, RESERVATION_NAME_FIELD, INSTANCE_COUNT_FIELD));

    private final String reservedInstanceOfferingId;

    private final String reservationName;

    private final Integer instanceCount;

    private PurchaseReservedInstanceOfferingRequest(BuilderImpl builder) {
        super(builder);
        this.reservedInstanceOfferingId = builder.reservedInstanceOfferingId;
        this.reservationName = builder.reservationName;
        this.instanceCount = builder.instanceCount;
    }

    /**
     * <p>
     * The ID of the Reserved Instance offering to purchase.
     * </p>
     * 
     * @return The ID of the Reserved Instance offering to purchase.
     */
    public final String reservedInstanceOfferingId() {
        return reservedInstanceOfferingId;
    }

    /**
     * <p>
     * A customer-specified identifier to track this reservation.
     * </p>
     * 
     * @return A customer-specified identifier to track this reservation.
     */
    public final String reservationName() {
        return reservationName;
    }

    /**
     * <p>
     * The number of OpenSearch instances to reserve.
     * </p>
     * 
     * @return The number of OpenSearch instances to reserve.
     */
    public final Integer instanceCount() {
        return instanceCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstanceOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(reservationName());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseReservedInstanceOfferingRequest)) {
            return false;
        }
        PurchaseReservedInstanceOfferingRequest other = (PurchaseReservedInstanceOfferingRequest) obj;
        return Objects.equals(reservedInstanceOfferingId(), other.reservedInstanceOfferingId())
                && Objects.equals(reservationName(), other.reservationName())
                && Objects.equals(instanceCount(), other.instanceCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PurchaseReservedInstanceOfferingRequest")
                .add("ReservedInstanceOfferingId", reservedInstanceOfferingId()).add("ReservationName", reservationName())
                .add("InstanceCount", instanceCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedInstanceOfferingId":
            return Optional.ofNullable(clazz.cast(reservedInstanceOfferingId()));
        case "ReservationName":
            return Optional.ofNullable(clazz.cast(reservationName()));
        case "InstanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PurchaseReservedInstanceOfferingRequest, T> g) {
        return obj -> g.apply((PurchaseReservedInstanceOfferingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PurchaseReservedInstanceOfferingRequest> {
        /**
         * <p>
         * The ID of the Reserved Instance offering to purchase.
         * </p>
         * 
         * @param reservedInstanceOfferingId
         *        The ID of the Reserved Instance offering to purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstanceOfferingId(String reservedInstanceOfferingId);

        /**
         * <p>
         * A customer-specified identifier to track this reservation.
         * </p>
         * 
         * @param reservationName
         *        A customer-specified identifier to track this reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservationName(String reservationName);

        /**
         * <p>
         * The number of OpenSearch instances to reserve.
         * </p>
         * 
         * @param instanceCount
         *        The number of OpenSearch instances to reserve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpenSearchRequest.BuilderImpl implements Builder {
        private String reservedInstanceOfferingId;

        private String reservationName;

        private Integer instanceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseReservedInstanceOfferingRequest model) {
            super(model);
            reservedInstanceOfferingId(model.reservedInstanceOfferingId);
            reservationName(model.reservationName);
            instanceCount(model.instanceCount);
        }

        public final String getReservedInstanceOfferingId() {
            return reservedInstanceOfferingId;
        }

        public final void setReservedInstanceOfferingId(String reservedInstanceOfferingId) {
            this.reservedInstanceOfferingId = reservedInstanceOfferingId;
        }

        @Override
        public final Builder reservedInstanceOfferingId(String reservedInstanceOfferingId) {
            this.reservedInstanceOfferingId = reservedInstanceOfferingId;
            return this;
        }

        public final String getReservationName() {
            return reservationName;
        }

        public final void setReservationName(String reservationName) {
            this.reservationName = reservationName;
        }

        @Override
        public final Builder reservationName(String reservationName) {
            this.reservationName = reservationName;
            return this;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PurchaseReservedInstanceOfferingRequest build() {
            return new PurchaseReservedInstanceOfferingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
