/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a package version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PackageVersionHistory implements SdkPojo, Serializable,
        ToCopyableBuilder<PackageVersionHistory.Builder, PackageVersionHistory> {
    private static final SdkField<String> PACKAGE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageVersion").getter(getter(PackageVersionHistory::packageVersion))
            .setter(setter(Builder::packageVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageVersion").build()).build();

    private static final SdkField<String> COMMIT_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CommitMessage").getter(getter(PackageVersionHistory::commitMessage))
            .setter(setter(Builder::commitMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommitMessage").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(PackageVersionHistory::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_VERSION_FIELD,
            COMMIT_MESSAGE_FIELD, CREATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String packageVersion;

    private final String commitMessage;

    private final Instant createdAt;

    private PackageVersionHistory(BuilderImpl builder) {
        this.packageVersion = builder.packageVersion;
        this.commitMessage = builder.commitMessage;
        this.createdAt = builder.createdAt;
    }

    /**
     * <p>
     * The package version.
     * </p>
     * 
     * @return The package version.
     */
    public final String packageVersion() {
        return packageVersion;
    }

    /**
     * <p>
     * A message associated with the package version when it was uploaded.
     * </p>
     * 
     * @return A message associated with the package version when it was uploaded.
     */
    public final String commitMessage() {
        return commitMessage;
    }

    /**
     * <p>
     * The date and time when the package was created.
     * </p>
     * 
     * @return The date and time when the package was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(packageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(commitMessage());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageVersionHistory)) {
            return false;
        }
        PackageVersionHistory other = (PackageVersionHistory) obj;
        return Objects.equals(packageVersion(), other.packageVersion()) && Objects.equals(commitMessage(), other.commitMessage())
                && Objects.equals(createdAt(), other.createdAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PackageVersionHistory").add("PackageVersion", packageVersion())
                .add("CommitMessage", commitMessage()).add("CreatedAt", createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PackageVersion":
            return Optional.ofNullable(clazz.cast(packageVersion()));
        case "CommitMessage":
            return Optional.ofNullable(clazz.cast(commitMessage()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PackageVersionHistory, T> g) {
        return obj -> g.apply((PackageVersionHistory) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PackageVersionHistory> {
        /**
         * <p>
         * The package version.
         * </p>
         * 
         * @param packageVersion
         *        The package version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageVersion(String packageVersion);

        /**
         * <p>
         * A message associated with the package version when it was uploaded.
         * </p>
         * 
         * @param commitMessage
         *        A message associated with the package version when it was uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitMessage(String commitMessage);

        /**
         * <p>
         * The date and time when the package was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time when the package was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);
    }

    static final class BuilderImpl implements Builder {
        private String packageVersion;

        private String commitMessage;

        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageVersionHistory model) {
            packageVersion(model.packageVersion);
            commitMessage(model.commitMessage);
            createdAt(model.createdAt);
        }

        public final String getPackageVersion() {
            return packageVersion;
        }

        public final void setPackageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
        }

        @Override
        public final Builder packageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        public final String getCommitMessage() {
            return commitMessage;
        }

        public final void setCommitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
        }

        @Override
        public final Builder commitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public PackageVersionHistory build() {
            return new PackageVersionHistory(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
