/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The results of a <code>ListDomainNames</code> operation. Contains the names of all domains owned by this account and
 * their respective engine types.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDomainNamesResponse extends OpenSearchResponse implements
        ToCopyableBuilder<ListDomainNamesResponse.Builder, ListDomainNamesResponse> {
    private static final SdkField<List<DomainInfo>> DOMAIN_NAMES_FIELD = SdkField
            .<List<DomainInfo>> builder(MarshallingType.LIST)
            .memberName("DomainNames")
            .getter(getter(ListDomainNamesResponse::domainNames))
            .setter(setter(Builder::domainNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DomainInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(DomainInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAMES_FIELD));

    private final List<DomainInfo> domainNames;

    private ListDomainNamesResponse(BuilderImpl builder) {
        super(builder);
        this.domainNames = builder.domainNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the DomainNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDomainNames() {
        return domainNames != null && !(domainNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of all OpenSearch Service domains owned by the current user and their respective engine types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDomainNames} method.
     * </p>
     * 
     * @return The names of all OpenSearch Service domains owned by the current user and their respective engine types.
     */
    public final List<DomainInfo> domainNames() {
        return domainNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDomainNames() ? domainNames() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainNamesResponse)) {
            return false;
        }
        ListDomainNamesResponse other = (ListDomainNamesResponse) obj;
        return hasDomainNames() == other.hasDomainNames() && Objects.equals(domainNames(), other.domainNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDomainNamesResponse").add("DomainNames", hasDomainNames() ? domainNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainNames":
            return Optional.ofNullable(clazz.cast(domainNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDomainNamesResponse, T> g) {
        return obj -> g.apply((ListDomainNamesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListDomainNamesResponse> {
        /**
         * <p>
         * The names of all OpenSearch Service domains owned by the current user and their respective engine types.
         * </p>
         * 
         * @param domainNames
         *        The names of all OpenSearch Service domains owned by the current user and their respective engine
         *        types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainNames(Collection<DomainInfo> domainNames);

        /**
         * <p>
         * The names of all OpenSearch Service domains owned by the current user and their respective engine types.
         * </p>
         * 
         * @param domainNames
         *        The names of all OpenSearch Service domains owned by the current user and their respective engine
         *        types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainNames(DomainInfo... domainNames);

        /**
         * <p>
         * The names of all OpenSearch Service domains owned by the current user and their respective engine types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opensearch.model.DomainInfo.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.opensearch.model.DomainInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opensearch.model.DomainInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #domainNames(List<DomainInfo>)}.
         * 
         * @param domainNames
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opensearch.model.DomainInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainNames(java.util.Collection<DomainInfo>)
         */
        Builder domainNames(Consumer<DomainInfo.Builder>... domainNames);
    }

    static final class BuilderImpl extends OpenSearchResponse.BuilderImpl implements Builder {
        private List<DomainInfo> domainNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListDomainNamesResponse model) {
            super(model);
            domainNames(model.domainNames);
        }

        public final List<DomainInfo.Builder> getDomainNames() {
            List<DomainInfo.Builder> result = DomainInfoListCopier.copyToBuilder(this.domainNames);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomainNames(Collection<DomainInfo.BuilderImpl> domainNames) {
            this.domainNames = DomainInfoListCopier.copyFromBuilder(domainNames);
        }

        @Override
        public final Builder domainNames(Collection<DomainInfo> domainNames) {
            this.domainNames = DomainInfoListCopier.copy(domainNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainNames(DomainInfo... domainNames) {
            domainNames(Arrays.asList(domainNames));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainNames(Consumer<DomainInfo.Builder>... domainNames) {
            domainNames(Stream.of(domainNames).map(c -> DomainInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListDomainNamesResponse build() {
            return new ListDomainNamesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
