/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for information about a configuration change happening on a domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChangeProgressDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ChangeProgressDetails.Builder, ChangeProgressDetails> {
    private static final SdkField<String> CHANGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeId").getter(getter(ChangeProgressDetails::changeId)).setter(setter(Builder::changeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeId").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(ChangeProgressDetails::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CHANGE_ID_FIELD, MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String changeId;

    private final String message;

    private ChangeProgressDetails(BuilderImpl builder) {
        this.changeId = builder.changeId;
        this.message = builder.message;
    }

    /**
     * <p>
     * The ID of the configuration change.
     * </p>
     * 
     * @return The ID of the configuration change.
     */
    public final String changeId() {
        return changeId;
    }

    /**
     * <p>
     * A message corresponding to the status of the configuration change.
     * </p>
     * 
     * @return A message corresponding to the status of the configuration change.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(changeId());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeProgressDetails)) {
            return false;
        }
        ChangeProgressDetails other = (ChangeProgressDetails) obj;
        return Objects.equals(changeId(), other.changeId()) && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChangeProgressDetails").add("ChangeId", changeId()).add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChangeId":
            return Optional.ofNullable(clazz.cast(changeId()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChangeProgressDetails, T> g) {
        return obj -> g.apply((ChangeProgressDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChangeProgressDetails> {
        /**
         * <p>
         * The ID of the configuration change.
         * </p>
         * 
         * @param changeId
         *        The ID of the configuration change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeId(String changeId);

        /**
         * <p>
         * A message corresponding to the status of the configuration change.
         * </p>
         * 
         * @param message
         *        A message corresponding to the status of the configuration change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String changeId;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeProgressDetails model) {
            changeId(model.changeId);
            message(model.message);
        }

        public final String getChangeId() {
            return changeId;
        }

        public final void setChangeId(String changeId) {
            this.changeId = changeId;
        }

        @Override
        public final Builder changeId(String changeId) {
            this.changeId = changeId;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public ChangeProgressDetails build() {
            return new ChangeProgressDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
