/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.opensearch.DefaultOpenSearchAsyncClient;
import software.amazon.awssdk.services.opensearch.DefaultOpenSearchBaseClientBuilder;
import software.amazon.awssdk.services.opensearch.OpenSearchAsyncClient;
import software.amazon.awssdk.services.opensearch.OpenSearchAsyncClientBuilder;
import software.amazon.awssdk.services.opensearch.OpenSearchServiceClientConfiguration;
import software.amazon.awssdk.services.opensearch.endpoints.OpenSearchEndpointProvider;

@SdkInternalApi
final class DefaultOpenSearchAsyncClientBuilder
extends DefaultOpenSearchBaseClientBuilder<OpenSearchAsyncClientBuilder, OpenSearchAsyncClient>
implements OpenSearchAsyncClientBuilder {
    DefaultOpenSearchAsyncClientBuilder() {
    }

    @Override
    public DefaultOpenSearchAsyncClientBuilder endpointProvider(OpenSearchEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final OpenSearchAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultOpenSearchAsyncClientBuilder.validateClientOptions(clientConfiguration);
        OpenSearchServiceClientConfiguration serviceClientConfiguration = OpenSearchServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultOpenSearchAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

