/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opensearch.OpenSearchAsyncClient;
import software.amazon.awssdk.services.opensearch.model.ListScheduledActionsRequest;
import software.amazon.awssdk.services.opensearch.model.ListScheduledActionsResponse;

public class ListScheduledActionsPublisher
implements SdkPublisher<ListScheduledActionsResponse> {
    private final OpenSearchAsyncClient client;
    private final ListScheduledActionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListScheduledActionsPublisher(OpenSearchAsyncClient client, ListScheduledActionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListScheduledActionsPublisher(OpenSearchAsyncClient client, ListScheduledActionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListScheduledActionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListScheduledActionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListScheduledActionsResponseFetcher
    implements AsyncPageFetcher<ListScheduledActionsResponse> {
        private ListScheduledActionsResponseFetcher() {
        }

        public boolean hasNextPage(ListScheduledActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListScheduledActionsResponse> nextPage(ListScheduledActionsResponse previousPage) {
            if (previousPage == null) {
                return ListScheduledActionsPublisher.this.client.listScheduledActions(ListScheduledActionsPublisher.this.firstRequest);
            }
            return ListScheduledActionsPublisher.this.client.listScheduledActions((ListScheduledActionsRequest)((Object)ListScheduledActionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

