/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opensearch.OpenSearchAsyncClient;
import software.amazon.awssdk.services.opensearch.model.ListVersionsRequest;
import software.amazon.awssdk.services.opensearch.model.ListVersionsResponse;

public class ListVersionsPublisher
implements SdkPublisher<ListVersionsResponse> {
    private final OpenSearchAsyncClient client;
    private final ListVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListVersionsPublisher(OpenSearchAsyncClient client, ListVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListVersionsPublisher(OpenSearchAsyncClient client, ListVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListVersionsResponseFetcher
    implements AsyncPageFetcher<ListVersionsResponse> {
        private ListVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListVersionsResponse> nextPage(ListVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListVersionsPublisher.this.client.listVersions(ListVersionsPublisher.this.firstRequest);
            }
            return ListVersionsPublisher.this.client.listVersions((ListVersionsRequest)((Object)ListVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

