/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WorkflowExport {
    DEFINITION("DEFINITION"),
    README("README"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WorkflowExport> VALUE_MAP;
    private final String value;

    private WorkflowExport(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WorkflowExport fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WorkflowExport> knownValues() {
        EnumSet<WorkflowExport> knownValues = EnumSet.allOf(WorkflowExport.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WorkflowExport.class, WorkflowExport::toString);
    }
}

