/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WorkflowEngine {
    WDL("WDL"),
    NEXTFLOW("NEXTFLOW"),
    CWL("CWL"),
    WDL_LENIENT("WDL_LENIENT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WorkflowEngine> VALUE_MAP;
    private final String value;

    private WorkflowEngine(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WorkflowEngine fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WorkflowEngine> knownValues() {
        EnumSet<WorkflowEngine> knownValues = EnumSet.allOf(WorkflowEngine.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WorkflowEngine.class, WorkflowEngine::toString);
    }
}

