/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegistryMapping
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RegistryMapping> {
    private static final SdkField<String> UPSTREAM_REGISTRY_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("upstreamRegistryUrl").getter(RegistryMapping.getter(RegistryMapping::upstreamRegistryUrl)).setter(RegistryMapping.setter(Builder::upstreamRegistryUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upstreamRegistryUrl").build()}).build();
    private static final SdkField<String> ECR_REPOSITORY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ecrRepositoryPrefix").getter(RegistryMapping.getter(RegistryMapping::ecrRepositoryPrefix)).setter(RegistryMapping.setter(Builder::ecrRepositoryPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrRepositoryPrefix").build()}).build();
    private static final SdkField<String> UPSTREAM_REPOSITORY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("upstreamRepositoryPrefix").getter(RegistryMapping.getter(RegistryMapping::upstreamRepositoryPrefix)).setter(RegistryMapping.setter(Builder::upstreamRepositoryPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upstreamRepositoryPrefix").build()}).build();
    private static final SdkField<String> ECR_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ecrAccountId").getter(RegistryMapping.getter(RegistryMapping::ecrAccountId)).setter(RegistryMapping.setter(Builder::ecrAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrAccountId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPSTREAM_REGISTRY_URL_FIELD, ECR_REPOSITORY_PREFIX_FIELD, UPSTREAM_REPOSITORY_PREFIX_FIELD, ECR_ACCOUNT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RegistryMapping.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String upstreamRegistryUrl;
    private final String ecrRepositoryPrefix;
    private final String upstreamRepositoryPrefix;
    private final String ecrAccountId;

    private RegistryMapping(BuilderImpl builder) {
        this.upstreamRegistryUrl = builder.upstreamRegistryUrl;
        this.ecrRepositoryPrefix = builder.ecrRepositoryPrefix;
        this.upstreamRepositoryPrefix = builder.upstreamRepositoryPrefix;
        this.ecrAccountId = builder.ecrAccountId;
    }

    public final String upstreamRegistryUrl() {
        return this.upstreamRegistryUrl;
    }

    public final String ecrRepositoryPrefix() {
        return this.ecrRepositoryPrefix;
    }

    public final String upstreamRepositoryPrefix() {
        return this.upstreamRepositoryPrefix;
    }

    public final String ecrAccountId() {
        return this.ecrAccountId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.upstreamRegistryUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.ecrRepositoryPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.upstreamRepositoryPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.ecrAccountId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegistryMapping)) {
            return false;
        }
        RegistryMapping other = (RegistryMapping)obj;
        return Objects.equals(this.upstreamRegistryUrl(), other.upstreamRegistryUrl()) && Objects.equals(this.ecrRepositoryPrefix(), other.ecrRepositoryPrefix()) && Objects.equals(this.upstreamRepositoryPrefix(), other.upstreamRepositoryPrefix()) && Objects.equals(this.ecrAccountId(), other.ecrAccountId());
    }

    public final String toString() {
        return ToString.builder((String)"RegistryMapping").add("UpstreamRegistryUrl", (Object)this.upstreamRegistryUrl()).add("EcrRepositoryPrefix", (Object)this.ecrRepositoryPrefix()).add("UpstreamRepositoryPrefix", (Object)this.upstreamRepositoryPrefix()).add("EcrAccountId", (Object)this.ecrAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "upstreamRegistryUrl": {
                return Optional.ofNullable(clazz.cast(this.upstreamRegistryUrl()));
            }
            case "ecrRepositoryPrefix": {
                return Optional.ofNullable(clazz.cast(this.ecrRepositoryPrefix()));
            }
            case "upstreamRepositoryPrefix": {
                return Optional.ofNullable(clazz.cast(this.upstreamRepositoryPrefix()));
            }
            case "ecrAccountId": {
                return Optional.ofNullable(clazz.cast(this.ecrAccountId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("upstreamRegistryUrl", UPSTREAM_REGISTRY_URL_FIELD);
        map.put("ecrRepositoryPrefix", ECR_REPOSITORY_PREFIX_FIELD);
        map.put("upstreamRepositoryPrefix", UPSTREAM_REPOSITORY_PREFIX_FIELD);
        map.put("ecrAccountId", ECR_ACCOUNT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegistryMapping, T> g) {
        return obj -> g.apply((RegistryMapping)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String upstreamRegistryUrl;
        private String ecrRepositoryPrefix;
        private String upstreamRepositoryPrefix;
        private String ecrAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(RegistryMapping model) {
            this.upstreamRegistryUrl(model.upstreamRegistryUrl);
            this.ecrRepositoryPrefix(model.ecrRepositoryPrefix);
            this.upstreamRepositoryPrefix(model.upstreamRepositoryPrefix);
            this.ecrAccountId(model.ecrAccountId);
        }

        public final String getUpstreamRegistryUrl() {
            return this.upstreamRegistryUrl;
        }

        public final void setUpstreamRegistryUrl(String upstreamRegistryUrl) {
            this.upstreamRegistryUrl = upstreamRegistryUrl;
        }

        @Override
        public final Builder upstreamRegistryUrl(String upstreamRegistryUrl) {
            this.upstreamRegistryUrl = upstreamRegistryUrl;
            return this;
        }

        public final String getEcrRepositoryPrefix() {
            return this.ecrRepositoryPrefix;
        }

        public final void setEcrRepositoryPrefix(String ecrRepositoryPrefix) {
            this.ecrRepositoryPrefix = ecrRepositoryPrefix;
        }

        @Override
        public final Builder ecrRepositoryPrefix(String ecrRepositoryPrefix) {
            this.ecrRepositoryPrefix = ecrRepositoryPrefix;
            return this;
        }

        public final String getUpstreamRepositoryPrefix() {
            return this.upstreamRepositoryPrefix;
        }

        public final void setUpstreamRepositoryPrefix(String upstreamRepositoryPrefix) {
            this.upstreamRepositoryPrefix = upstreamRepositoryPrefix;
        }

        @Override
        public final Builder upstreamRepositoryPrefix(String upstreamRepositoryPrefix) {
            this.upstreamRepositoryPrefix = upstreamRepositoryPrefix;
            return this;
        }

        public final String getEcrAccountId() {
            return this.ecrAccountId;
        }

        public final void setEcrAccountId(String ecrAccountId) {
            this.ecrAccountId = ecrAccountId;
        }

        @Override
        public final Builder ecrAccountId(String ecrAccountId) {
            this.ecrAccountId = ecrAccountId;
            return this;
        }

        public RegistryMapping build() {
            return new RegistryMapping(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RegistryMapping> {
        public Builder upstreamRegistryUrl(String var1);

        public Builder ecrRepositoryPrefix(String var1);

        public Builder upstreamRepositoryPrefix(String var1);

        public Builder ecrAccountId(String var1);
    }
}

