/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.omics.model.TsvOptions;
import software.amazon.awssdk.services.omics.model.VcfOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FormatOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FormatOptions> {
    private static final SdkField<TsvOptions> TSV_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tsvOptions").getter(FormatOptions.getter(FormatOptions::tsvOptions)).setter(FormatOptions.setter(Builder::tsvOptions)).constructor(TsvOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tsvOptions").build()}).build();
    private static final SdkField<VcfOptions> VCF_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vcfOptions").getter(FormatOptions.getter(FormatOptions::vcfOptions)).setter(FormatOptions.setter(Builder::vcfOptions)).constructor(VcfOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vcfOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TSV_OPTIONS_FIELD, VCF_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FormatOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final TsvOptions tsvOptions;
    private final VcfOptions vcfOptions;
    private final Type type;

    private FormatOptions(BuilderImpl builder) {
        this.tsvOptions = builder.tsvOptions;
        this.vcfOptions = builder.vcfOptions;
        this.type = builder.type;
    }

    public final TsvOptions tsvOptions() {
        return this.tsvOptions;
    }

    public final VcfOptions vcfOptions() {
        return this.vcfOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tsvOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.vcfOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FormatOptions)) {
            return false;
        }
        FormatOptions other = (FormatOptions)obj;
        return Objects.equals(this.tsvOptions(), other.tsvOptions()) && Objects.equals(this.vcfOptions(), other.vcfOptions());
    }

    public final String toString() {
        return ToString.builder((String)"FormatOptions").add("TsvOptions", (Object)this.tsvOptions()).add("VcfOptions", (Object)this.vcfOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tsvOptions": {
                return Optional.ofNullable(clazz.cast(this.tsvOptions()));
            }
            case "vcfOptions": {
                return Optional.ofNullable(clazz.cast(this.vcfOptions()));
            }
        }
        return Optional.empty();
    }

    public static FormatOptions fromTsvOptions(TsvOptions tsvOptions) {
        return (FormatOptions)FormatOptions.builder().tsvOptions(tsvOptions).build();
    }

    public static FormatOptions fromTsvOptions(Consumer<TsvOptions.Builder> tsvOptions) {
        TsvOptions.Builder builder = TsvOptions.builder();
        tsvOptions.accept(builder);
        return FormatOptions.fromTsvOptions((TsvOptions)builder.build());
    }

    public static FormatOptions fromVcfOptions(VcfOptions vcfOptions) {
        return (FormatOptions)FormatOptions.builder().vcfOptions(vcfOptions).build();
    }

    public static FormatOptions fromVcfOptions(Consumer<VcfOptions.Builder> vcfOptions) {
        VcfOptions.Builder builder = VcfOptions.builder();
        vcfOptions.accept(builder);
        return FormatOptions.fromVcfOptions((VcfOptions)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tsvOptions", TSV_OPTIONS_FIELD);
        map.put("vcfOptions", VCF_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FormatOptions, T> g) {
        return obj -> g.apply((FormatOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        TSV_OPTIONS,
        VCF_OPTIONS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private TsvOptions tsvOptions;
        private VcfOptions vcfOptions;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(FormatOptions model) {
            this.tsvOptions(model.tsvOptions);
            this.vcfOptions(model.vcfOptions);
        }

        public final TsvOptions.Builder getTsvOptions() {
            return this.tsvOptions != null ? this.tsvOptions.toBuilder() : null;
        }

        public final void setTsvOptions(TsvOptions.BuilderImpl tsvOptions) {
            TsvOptions oldValue = this.tsvOptions;
            this.tsvOptions = tsvOptions != null ? tsvOptions.build() : null;
            this.handleUnionValueChange(Type.TSV_OPTIONS, oldValue, this.tsvOptions);
        }

        @Override
        public final Builder tsvOptions(TsvOptions tsvOptions) {
            TsvOptions oldValue = this.tsvOptions;
            this.tsvOptions = tsvOptions;
            this.handleUnionValueChange(Type.TSV_OPTIONS, oldValue, this.tsvOptions);
            return this;
        }

        public final VcfOptions.Builder getVcfOptions() {
            return this.vcfOptions != null ? this.vcfOptions.toBuilder() : null;
        }

        public final void setVcfOptions(VcfOptions.BuilderImpl vcfOptions) {
            VcfOptions oldValue = this.vcfOptions;
            this.vcfOptions = vcfOptions != null ? vcfOptions.build() : null;
            this.handleUnionValueChange(Type.VCF_OPTIONS, oldValue, this.vcfOptions);
        }

        @Override
        public final Builder vcfOptions(VcfOptions vcfOptions) {
            VcfOptions oldValue = this.vcfOptions;
            this.vcfOptions = vcfOptions;
            this.handleUnionValueChange(Type.VCF_OPTIONS, oldValue, this.vcfOptions);
            return this;
        }

        public FormatOptions build() {
            return new FormatOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FormatOptions> {
        public Builder tsvOptions(TsvOptions var1);

        default public Builder tsvOptions(Consumer<TsvOptions.Builder> tsvOptions) {
            return this.tsvOptions((TsvOptions)((TsvOptions.Builder)TsvOptions.builder().applyMutation(tsvOptions)).build());
        }

        public Builder vcfOptions(VcfOptions var1);

        default public Builder vcfOptions(Consumer<VcfOptions.Builder> vcfOptions) {
            return this.vcfOptions((VcfOptions)((VcfOptions.Builder)VcfOptions.builder().applyMutation(vcfOptions)).build());
        }
    }
}

