/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.omics.model.ExcludeFilePatternListCopier;
import software.amazon.awssdk.services.omics.model.SourceReference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DefinitionRepository
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DefinitionRepository> {
    private static final SdkField<String> CONNECTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectionArn").getter(DefinitionRepository.getter(DefinitionRepository::connectionArn)).setter(DefinitionRepository.setter(Builder::connectionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionArn").build()}).build();
    private static final SdkField<String> FULL_REPOSITORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fullRepositoryId").getter(DefinitionRepository.getter(DefinitionRepository::fullRepositoryId)).setter(DefinitionRepository.setter(Builder::fullRepositoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fullRepositoryId").build()}).build();
    private static final SdkField<SourceReference> SOURCE_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceReference").getter(DefinitionRepository.getter(DefinitionRepository::sourceReference)).setter(DefinitionRepository.setter(Builder::sourceReference)).constructor(SourceReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceReference").build()}).build();
    private static final SdkField<List<String>> EXCLUDE_FILE_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("excludeFilePatterns").getter(DefinitionRepository.getter(DefinitionRepository::excludeFilePatterns)).setter(DefinitionRepository.setter(Builder::excludeFilePatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excludeFilePatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ARN_FIELD, FULL_REPOSITORY_ID_FIELD, SOURCE_REFERENCE_FIELD, EXCLUDE_FILE_PATTERNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DefinitionRepository.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String connectionArn;
    private final String fullRepositoryId;
    private final SourceReference sourceReference;
    private final List<String> excludeFilePatterns;

    private DefinitionRepository(BuilderImpl builder) {
        this.connectionArn = builder.connectionArn;
        this.fullRepositoryId = builder.fullRepositoryId;
        this.sourceReference = builder.sourceReference;
        this.excludeFilePatterns = builder.excludeFilePatterns;
    }

    public final String connectionArn() {
        return this.connectionArn;
    }

    public final String fullRepositoryId() {
        return this.fullRepositoryId;
    }

    public final SourceReference sourceReference() {
        return this.sourceReference;
    }

    public final boolean hasExcludeFilePatterns() {
        return this.excludeFilePatterns != null && !(this.excludeFilePatterns instanceof SdkAutoConstructList);
    }

    public final List<String> excludeFilePatterns() {
        return this.excludeFilePatterns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.fullRepositoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludeFilePatterns() ? this.excludeFilePatterns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefinitionRepository)) {
            return false;
        }
        DefinitionRepository other = (DefinitionRepository)obj;
        return Objects.equals(this.connectionArn(), other.connectionArn()) && Objects.equals(this.fullRepositoryId(), other.fullRepositoryId()) && Objects.equals(this.sourceReference(), other.sourceReference()) && this.hasExcludeFilePatterns() == other.hasExcludeFilePatterns() && Objects.equals(this.excludeFilePatterns(), other.excludeFilePatterns());
    }

    public final String toString() {
        return ToString.builder((String)"DefinitionRepository").add("ConnectionArn", (Object)this.connectionArn()).add("FullRepositoryId", (Object)this.fullRepositoryId()).add("SourceReference", (Object)this.sourceReference()).add("ExcludeFilePatterns", this.hasExcludeFilePatterns() ? this.excludeFilePatterns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectionArn": {
                return Optional.ofNullable(clazz.cast(this.connectionArn()));
            }
            case "fullRepositoryId": {
                return Optional.ofNullable(clazz.cast(this.fullRepositoryId()));
            }
            case "sourceReference": {
                return Optional.ofNullable(clazz.cast(this.sourceReference()));
            }
            case "excludeFilePatterns": {
                return Optional.ofNullable(clazz.cast(this.excludeFilePatterns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("connectionArn", CONNECTION_ARN_FIELD);
        map.put("fullRepositoryId", FULL_REPOSITORY_ID_FIELD);
        map.put("sourceReference", SOURCE_REFERENCE_FIELD);
        map.put("excludeFilePatterns", EXCLUDE_FILE_PATTERNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DefinitionRepository, T> g) {
        return obj -> g.apply((DefinitionRepository)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String connectionArn;
        private String fullRepositoryId;
        private SourceReference sourceReference;
        private List<String> excludeFilePatterns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DefinitionRepository model) {
            this.connectionArn(model.connectionArn);
            this.fullRepositoryId(model.fullRepositoryId);
            this.sourceReference(model.sourceReference);
            this.excludeFilePatterns(model.excludeFilePatterns);
        }

        public final String getConnectionArn() {
            return this.connectionArn;
        }

        public final void setConnectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
        }

        @Override
        public final Builder connectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
            return this;
        }

        public final String getFullRepositoryId() {
            return this.fullRepositoryId;
        }

        public final void setFullRepositoryId(String fullRepositoryId) {
            this.fullRepositoryId = fullRepositoryId;
        }

        @Override
        public final Builder fullRepositoryId(String fullRepositoryId) {
            this.fullRepositoryId = fullRepositoryId;
            return this;
        }

        public final SourceReference.Builder getSourceReference() {
            return this.sourceReference != null ? this.sourceReference.toBuilder() : null;
        }

        public final void setSourceReference(SourceReference.BuilderImpl sourceReference) {
            this.sourceReference = sourceReference != null ? sourceReference.build() : null;
        }

        @Override
        public final Builder sourceReference(SourceReference sourceReference) {
            this.sourceReference = sourceReference;
            return this;
        }

        public final Collection<String> getExcludeFilePatterns() {
            if (this.excludeFilePatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.excludeFilePatterns;
        }

        public final void setExcludeFilePatterns(Collection<String> excludeFilePatterns) {
            this.excludeFilePatterns = ExcludeFilePatternListCopier.copy(excludeFilePatterns);
        }

        @Override
        public final Builder excludeFilePatterns(Collection<String> excludeFilePatterns) {
            this.excludeFilePatterns = ExcludeFilePatternListCopier.copy(excludeFilePatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeFilePatterns(String ... excludeFilePatterns) {
            this.excludeFilePatterns(Arrays.asList(excludeFilePatterns));
            return this;
        }

        public DefinitionRepository build() {
            return new DefinitionRepository(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DefinitionRepository> {
        public Builder connectionArn(String var1);

        public Builder fullRepositoryId(String var1);

        public Builder sourceReference(SourceReference var1);

        default public Builder sourceReference(Consumer<SourceReference.Builder> sourceReference) {
            return this.sourceReference((SourceReference)((SourceReference.Builder)SourceReference.builder().applyMutation(sourceReference)).build());
        }

        public Builder excludeFilePatterns(Collection<String> var1);

        public Builder excludeFilePatterns(String ... var1);
    }
}

