/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsAsyncClient;
import software.amazon.awssdk.services.omics.internal.UserAgentUtils;
import software.amazon.awssdk.services.omics.model.ListRunsRequest;
import software.amazon.awssdk.services.omics.model.ListRunsResponse;
import software.amazon.awssdk.services.omics.model.RunListItem;

public class ListRunsPublisher
implements SdkPublisher<ListRunsResponse> {
    private final OmicsAsyncClient client;
    private final ListRunsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRunsPublisher(OmicsAsyncClient client, ListRunsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRunsPublisher(OmicsAsyncClient client, ListRunsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRunsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRunsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RunListItem> items() {
        Function<ListRunsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRunsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRunsResponseFetcher
    implements AsyncPageFetcher<ListRunsResponse> {
        private ListRunsResponseFetcher() {
        }

        public boolean hasNextPage(ListRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRunsResponse> nextPage(ListRunsResponse previousPage) {
            if (previousPage == null) {
                return ListRunsPublisher.this.client.listRuns(ListRunsPublisher.this.firstRequest);
            }
            return ListRunsPublisher.this.client.listRuns((ListRunsRequest)((Object)ListRunsPublisher.this.firstRequest.toBuilder().startingToken(previousPage.nextToken()).build()));
        }
    }
}

