/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.omics.model.MultipartReadSetUploadListCopier;
import software.amazon.awssdk.services.omics.model.MultipartReadSetUploadListItem;
import software.amazon.awssdk.services.omics.model.OmicsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMultipartReadSetUploadsResponse
extends OmicsResponse
implements ToCopyableBuilder<Builder, ListMultipartReadSetUploadsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListMultipartReadSetUploadsResponse.getter(ListMultipartReadSetUploadsResponse::nextToken)).setter(ListMultipartReadSetUploadsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<MultipartReadSetUploadListItem>> UPLOADS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("uploads").getter(ListMultipartReadSetUploadsResponse.getter(ListMultipartReadSetUploadsResponse::uploads)).setter(ListMultipartReadSetUploadsResponse.setter(Builder::uploads)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploads").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MultipartReadSetUploadListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, UPLOADS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListMultipartReadSetUploadsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<MultipartReadSetUploadListItem> uploads;

    private ListMultipartReadSetUploadsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.uploads = builder.uploads;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasUploads() {
        return this.uploads != null && !(this.uploads instanceof SdkAutoConstructList);
    }

    public final List<MultipartReadSetUploadListItem> uploads() {
        return this.uploads;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUploads() ? this.uploads() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMultipartReadSetUploadsResponse)) {
            return false;
        }
        ListMultipartReadSetUploadsResponse other = (ListMultipartReadSetUploadsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasUploads() == other.hasUploads() && Objects.equals(this.uploads(), other.uploads());
    }

    public final String toString() {
        return ToString.builder((String)"ListMultipartReadSetUploadsResponse").add("NextToken", (Object)this.nextToken()).add("Uploads", this.hasUploads() ? this.uploads() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "uploads": {
                return Optional.ofNullable(clazz.cast(this.uploads()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("uploads", UPLOADS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMultipartReadSetUploadsResponse, T> g) {
        return obj -> g.apply((ListMultipartReadSetUploadsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<MultipartReadSetUploadListItem> uploads = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListMultipartReadSetUploadsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.uploads(model.uploads);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<MultipartReadSetUploadListItem.Builder> getUploads() {
            List<MultipartReadSetUploadListItem.Builder> result = MultipartReadSetUploadListCopier.copyToBuilder(this.uploads);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUploads(Collection<MultipartReadSetUploadListItem.BuilderImpl> uploads) {
            this.uploads = MultipartReadSetUploadListCopier.copyFromBuilder(uploads);
        }

        @Override
        public final Builder uploads(Collection<MultipartReadSetUploadListItem> uploads) {
            this.uploads = MultipartReadSetUploadListCopier.copy(uploads);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder uploads(MultipartReadSetUploadListItem ... uploads) {
            this.uploads(Arrays.asList(uploads));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder uploads(Consumer<MultipartReadSetUploadListItem.Builder> ... uploads) {
            this.uploads(Stream.of(uploads).map(c -> (MultipartReadSetUploadListItem)((MultipartReadSetUploadListItem.Builder)MultipartReadSetUploadListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListMultipartReadSetUploadsResponse build() {
            return new ListMultipartReadSetUploadsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OmicsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMultipartReadSetUploadsResponse> {
        public Builder nextToken(String var1);

        public Builder uploads(Collection<MultipartReadSetUploadListItem> var1);

        public Builder uploads(MultipartReadSetUploadListItem ... var1);

        public Builder uploads(Consumer<MultipartReadSetUploadListItem.Builder> ... var1);
    }
}

