/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.omics.model.OmicsRequest;
import software.amazon.awssdk.services.omics.model.StorageType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateWorkflowVersionRequest
extends OmicsRequest
implements ToCopyableBuilder<Builder, UpdateWorkflowVersionRequest> {
    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowId").getter(UpdateWorkflowVersionRequest.getter(UpdateWorkflowVersionRequest::workflowId)).setter(UpdateWorkflowVersionRequest.setter(Builder::workflowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workflowId").build()}).build();
    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionName").getter(UpdateWorkflowVersionRequest.getter(UpdateWorkflowVersionRequest::versionName)).setter(UpdateWorkflowVersionRequest.setter(Builder::versionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("versionName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateWorkflowVersionRequest.getter(UpdateWorkflowVersionRequest::description)).setter(UpdateWorkflowVersionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storageType").getter(UpdateWorkflowVersionRequest.getter(UpdateWorkflowVersionRequest::storageTypeAsString)).setter(UpdateWorkflowVersionRequest.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageType").build()}).build();
    private static final SdkField<Integer> STORAGE_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("storageCapacity").getter(UpdateWorkflowVersionRequest.getter(UpdateWorkflowVersionRequest::storageCapacity)).setter(UpdateWorkflowVersionRequest.setter(Builder::storageCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageCapacity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_ID_FIELD, VERSION_NAME_FIELD, DESCRIPTION_FIELD, STORAGE_TYPE_FIELD, STORAGE_CAPACITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateWorkflowVersionRequest.memberNameToFieldInitializer();
    private final String workflowId;
    private final String versionName;
    private final String description;
    private final String storageType;
    private final Integer storageCapacity;

    private UpdateWorkflowVersionRequest(BuilderImpl builder) {
        super(builder);
        this.workflowId = builder.workflowId;
        this.versionName = builder.versionName;
        this.description = builder.description;
        this.storageType = builder.storageType;
        this.storageCapacity = builder.storageCapacity;
    }

    public final String workflowId() {
        return this.workflowId;
    }

    public final String versionName() {
        return this.versionName;
    }

    public final String description() {
        return this.description;
    }

    public final StorageType storageType() {
        return StorageType.fromValue(this.storageType);
    }

    public final String storageTypeAsString() {
        return this.storageType;
    }

    public final Integer storageCapacity() {
        return this.storageCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageCapacity());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkflowVersionRequest)) {
            return false;
        }
        UpdateWorkflowVersionRequest other = (UpdateWorkflowVersionRequest)((Object)obj);
        return Objects.equals(this.workflowId(), other.workflowId()) && Objects.equals(this.versionName(), other.versionName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.storageTypeAsString(), other.storageTypeAsString()) && Objects.equals(this.storageCapacity(), other.storageCapacity());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateWorkflowVersionRequest").add("WorkflowId", (Object)this.workflowId()).add("VersionName", (Object)this.versionName()).add("Description", (Object)this.description()).add("StorageType", (Object)this.storageTypeAsString()).add("StorageCapacity", (Object)this.storageCapacity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workflowId": {
                return Optional.ofNullable(clazz.cast(this.workflowId()));
            }
            case "versionName": {
                return Optional.ofNullable(clazz.cast(this.versionName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "storageType": {
                return Optional.ofNullable(clazz.cast(this.storageTypeAsString()));
            }
            case "storageCapacity": {
                return Optional.ofNullable(clazz.cast(this.storageCapacity()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("workflowId", WORKFLOW_ID_FIELD);
        map.put("versionName", VERSION_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("storageType", STORAGE_TYPE_FIELD);
        map.put("storageCapacity", STORAGE_CAPACITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkflowVersionRequest, T> g) {
        return obj -> g.apply((UpdateWorkflowVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsRequest.BuilderImpl
    implements Builder {
        private String workflowId;
        private String versionName;
        private String description;
        private String storageType;
        private Integer storageCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkflowVersionRequest model) {
            super(model);
            this.workflowId(model.workflowId);
            this.versionName(model.versionName);
            this.description(model.description);
            this.storageType(model.storageType);
            this.storageCapacity(model.storageCapacity);
        }

        public final String getWorkflowId() {
            return this.workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final String getVersionName() {
            return this.versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        @Override
        public final Builder storageType(StorageType storageType) {
            this.storageType(storageType == null ? null : storageType.toString());
            return this;
        }

        public final Integer getStorageCapacity() {
            return this.storageCapacity;
        }

        public final void setStorageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
        }

        @Override
        public final Builder storageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkflowVersionRequest build() {
            return new UpdateWorkflowVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OmicsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateWorkflowVersionRequest> {
        public Builder workflowId(String var1);

        public Builder versionName(String var1);

        public Builder description(String var1);

        public Builder storageType(String var1);

        public Builder storageType(StorageType var1);

        public Builder storageCapacity(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

