/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.omics.model.TaskStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaskListItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TaskListItem> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskId").getter(TaskListItem.getter(TaskListItem::taskId)).setter(TaskListItem.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(TaskListItem.getter(TaskListItem::statusAsString)).setter(TaskListItem.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(TaskListItem.getter(TaskListItem::name)).setter(TaskListItem.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Integer> CPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("cpus").getter(TaskListItem.getter(TaskListItem::cpus)).setter(TaskListItem.setter(Builder::cpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpus").build()}).build();
    private static final SdkField<Boolean> CACHE_HIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("cacheHit").getter(TaskListItem.getter(TaskListItem::cacheHit)).setter(TaskListItem.setter(Builder::cacheHit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheHit").build()}).build();
    private static final SdkField<String> CACHE_S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cacheS3Uri").getter(TaskListItem.getter(TaskListItem::cacheS3Uri)).setter(TaskListItem.setter(Builder::cacheS3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheS3Uri").build()}).build();
    private static final SdkField<Integer> MEMORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("memory").getter(TaskListItem.getter(TaskListItem::memory)).setter(TaskListItem.setter(Builder::memory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(TaskListItem.getter(TaskListItem::creationTime)).setter(TaskListItem.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(TaskListItem.getter(TaskListItem::startTime)).setter(TaskListItem.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> STOP_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("stopTime").getter(TaskListItem.getter(TaskListItem::stopTime)).setter(TaskListItem.setter(Builder::stopTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Integer> GPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("gpus").getter(TaskListItem.getter(TaskListItem::gpus)).setter(TaskListItem.setter(Builder::gpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gpus").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceType").getter(TaskListItem.getter(TaskListItem::instanceType)).setter(TaskListItem.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD, STATUS_FIELD, NAME_FIELD, CPUS_FIELD, CACHE_HIT_FIELD, CACHE_S3_URI_FIELD, MEMORY_FIELD, CREATION_TIME_FIELD, START_TIME_FIELD, STOP_TIME_FIELD, GPUS_FIELD, INSTANCE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TaskListItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String taskId;
    private final String status;
    private final String name;
    private final Integer cpus;
    private final Boolean cacheHit;
    private final String cacheS3Uri;
    private final Integer memory;
    private final Instant creationTime;
    private final Instant startTime;
    private final Instant stopTime;
    private final Integer gpus;
    private final String instanceType;

    private TaskListItem(BuilderImpl builder) {
        this.taskId = builder.taskId;
        this.status = builder.status;
        this.name = builder.name;
        this.cpus = builder.cpus;
        this.cacheHit = builder.cacheHit;
        this.cacheS3Uri = builder.cacheS3Uri;
        this.memory = builder.memory;
        this.creationTime = builder.creationTime;
        this.startTime = builder.startTime;
        this.stopTime = builder.stopTime;
        this.gpus = builder.gpus;
        this.instanceType = builder.instanceType;
    }

    public final String taskId() {
        return this.taskId;
    }

    public final TaskStatus status() {
        return TaskStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String name() {
        return this.name;
    }

    public final Integer cpus() {
        return this.cpus;
    }

    public final Boolean cacheHit() {
        return this.cacheHit;
    }

    public final String cacheS3Uri() {
        return this.cacheS3Uri;
    }

    public final Integer memory() {
        return this.memory;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant stopTime() {
        return this.stopTime;
    }

    public final Integer gpus() {
        return this.gpus;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheHit());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.memory());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.gpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskListItem)) {
            return false;
        }
        TaskListItem other = (TaskListItem)obj;
        return Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.cpus(), other.cpus()) && Objects.equals(this.cacheHit(), other.cacheHit()) && Objects.equals(this.cacheS3Uri(), other.cacheS3Uri()) && Objects.equals(this.memory(), other.memory()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.stopTime(), other.stopTime()) && Objects.equals(this.gpus(), other.gpus()) && Objects.equals(this.instanceType(), other.instanceType());
    }

    public final String toString() {
        return ToString.builder((String)"TaskListItem").add("TaskId", (Object)this.taskId()).add("Status", (Object)this.statusAsString()).add("Name", (Object)this.name()).add("Cpus", (Object)this.cpus()).add("CacheHit", (Object)this.cacheHit()).add("CacheS3Uri", (Object)this.cacheS3Uri()).add("Memory", (Object)this.memory()).add("CreationTime", (Object)this.creationTime()).add("StartTime", (Object)this.startTime()).add("StopTime", (Object)this.stopTime()).add("Gpus", (Object)this.gpus()).add("InstanceType", (Object)this.instanceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "cpus": {
                return Optional.ofNullable(clazz.cast(this.cpus()));
            }
            case "cacheHit": {
                return Optional.ofNullable(clazz.cast(this.cacheHit()));
            }
            case "cacheS3Uri": {
                return Optional.ofNullable(clazz.cast(this.cacheS3Uri()));
            }
            case "memory": {
                return Optional.ofNullable(clazz.cast(this.memory()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "stopTime": {
                return Optional.ofNullable(clazz.cast(this.stopTime()));
            }
            case "gpus": {
                return Optional.ofNullable(clazz.cast(this.gpus()));
            }
            case "instanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("taskId", TASK_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("cpus", CPUS_FIELD);
        map.put("cacheHit", CACHE_HIT_FIELD);
        map.put("cacheS3Uri", CACHE_S3_URI_FIELD);
        map.put("memory", MEMORY_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("stopTime", STOP_TIME_FIELD);
        map.put("gpus", GPUS_FIELD);
        map.put("instanceType", INSTANCE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TaskListItem, T> g) {
        return obj -> g.apply((TaskListItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String taskId;
        private String status;
        private String name;
        private Integer cpus;
        private Boolean cacheHit;
        private String cacheS3Uri;
        private Integer memory;
        private Instant creationTime;
        private Instant startTime;
        private Instant stopTime;
        private Integer gpus;
        private String instanceType;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskListItem model) {
            this.taskId(model.taskId);
            this.status(model.status);
            this.name(model.name);
            this.cpus(model.cpus);
            this.cacheHit(model.cacheHit);
            this.cacheS3Uri(model.cacheS3Uri);
            this.memory(model.memory);
            this.creationTime(model.creationTime);
            this.startTime(model.startTime);
            this.stopTime(model.stopTime);
            this.gpus(model.gpus);
            this.instanceType(model.instanceType);
        }

        public final String getTaskId() {
            return this.taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaskStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getCpus() {
            return this.cpus;
        }

        public final void setCpus(Integer cpus) {
            this.cpus = cpus;
        }

        @Override
        public final Builder cpus(Integer cpus) {
            this.cpus = cpus;
            return this;
        }

        public final Boolean getCacheHit() {
            return this.cacheHit;
        }

        public final void setCacheHit(Boolean cacheHit) {
            this.cacheHit = cacheHit;
        }

        @Override
        public final Builder cacheHit(Boolean cacheHit) {
            this.cacheHit = cacheHit;
            return this;
        }

        public final String getCacheS3Uri() {
            return this.cacheS3Uri;
        }

        public final void setCacheS3Uri(String cacheS3Uri) {
            this.cacheS3Uri = cacheS3Uri;
        }

        @Override
        public final Builder cacheS3Uri(String cacheS3Uri) {
            this.cacheS3Uri = cacheS3Uri;
            return this;
        }

        public final Integer getMemory() {
            return this.memory;
        }

        public final void setMemory(Integer memory) {
            this.memory = memory;
        }

        @Override
        public final Builder memory(Integer memory) {
            this.memory = memory;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getStopTime() {
            return this.stopTime;
        }

        public final void setStopTime(Instant stopTime) {
            this.stopTime = stopTime;
        }

        @Override
        public final Builder stopTime(Instant stopTime) {
            this.stopTime = stopTime;
            return this;
        }

        public final Integer getGpus() {
            return this.gpus;
        }

        public final void setGpus(Integer gpus) {
            this.gpus = gpus;
        }

        @Override
        public final Builder gpus(Integer gpus) {
            this.gpus = gpus;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public TaskListItem build() {
            return new TaskListItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TaskListItem> {
        public Builder taskId(String var1);

        public Builder status(String var1);

        public Builder status(TaskStatus var1);

        public Builder name(String var1);

        public Builder cpus(Integer var1);

        public Builder cacheHit(Boolean var1);

        public Builder cacheS3Uri(String var1);

        public Builder memory(Integer var1);

        public Builder creationTime(Instant var1);

        public Builder startTime(Instant var1);

        public Builder stopTime(Instant var1);

        public Builder gpus(Integer var1);

        public Builder instanceType(String var1);
    }
}

