/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SequenceStoreS3Access
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SequenceStoreS3Access> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3Uri").getter(SequenceStoreS3Access.getter(SequenceStoreS3Access::s3Uri)).setter(SequenceStoreS3Access.setter(Builder::s3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Uri").build()}).build();
    private static final SdkField<String> S3_ACCESS_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3AccessPointArn").getter(SequenceStoreS3Access.getter(SequenceStoreS3Access::s3AccessPointArn)).setter(SequenceStoreS3Access.setter(Builder::s3AccessPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3AccessPointArn").build()}).build();
    private static final SdkField<String> ACCESS_LOG_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accessLogLocation").getter(SequenceStoreS3Access.getter(SequenceStoreS3Access::accessLogLocation)).setter(SequenceStoreS3Access.setter(Builder::accessLogLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessLogLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_URI_FIELD, S3_ACCESS_POINT_ARN_FIELD, ACCESS_LOG_LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SequenceStoreS3Access.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String s3Uri;
    private final String s3AccessPointArn;
    private final String accessLogLocation;

    private SequenceStoreS3Access(BuilderImpl builder) {
        this.s3Uri = builder.s3Uri;
        this.s3AccessPointArn = builder.s3AccessPointArn;
        this.accessLogLocation = builder.accessLogLocation;
    }

    public final String s3Uri() {
        return this.s3Uri;
    }

    public final String s3AccessPointArn() {
        return this.s3AccessPointArn;
    }

    public final String accessLogLocation() {
        return this.accessLogLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3AccessPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessLogLocation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SequenceStoreS3Access)) {
            return false;
        }
        SequenceStoreS3Access other = (SequenceStoreS3Access)obj;
        return Objects.equals(this.s3Uri(), other.s3Uri()) && Objects.equals(this.s3AccessPointArn(), other.s3AccessPointArn()) && Objects.equals(this.accessLogLocation(), other.accessLogLocation());
    }

    public final String toString() {
        return ToString.builder((String)"SequenceStoreS3Access").add("S3Uri", (Object)this.s3Uri()).add("S3AccessPointArn", (Object)this.s3AccessPointArn()).add("AccessLogLocation", (Object)this.accessLogLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3Uri": {
                return Optional.ofNullable(clazz.cast(this.s3Uri()));
            }
            case "s3AccessPointArn": {
                return Optional.ofNullable(clazz.cast(this.s3AccessPointArn()));
            }
            case "accessLogLocation": {
                return Optional.ofNullable(clazz.cast(this.accessLogLocation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("s3Uri", S3_URI_FIELD);
        map.put("s3AccessPointArn", S3_ACCESS_POINT_ARN_FIELD);
        map.put("accessLogLocation", ACCESS_LOG_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SequenceStoreS3Access, T> g) {
        return obj -> g.apply((SequenceStoreS3Access)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3Uri;
        private String s3AccessPointArn;
        private String accessLogLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(SequenceStoreS3Access model) {
            this.s3Uri(model.s3Uri);
            this.s3AccessPointArn(model.s3AccessPointArn);
            this.accessLogLocation(model.accessLogLocation);
        }

        public final String getS3Uri() {
            return this.s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final String getS3AccessPointArn() {
            return this.s3AccessPointArn;
        }

        public final void setS3AccessPointArn(String s3AccessPointArn) {
            this.s3AccessPointArn = s3AccessPointArn;
        }

        @Override
        public final Builder s3AccessPointArn(String s3AccessPointArn) {
            this.s3AccessPointArn = s3AccessPointArn;
            return this;
        }

        public final String getAccessLogLocation() {
            return this.accessLogLocation;
        }

        public final void setAccessLogLocation(String accessLogLocation) {
            this.accessLogLocation = accessLogLocation;
        }

        @Override
        public final Builder accessLogLocation(String accessLogLocation) {
            this.accessLogLocation = accessLogLocation;
            return this;
        }

        public SequenceStoreS3Access build() {
            return new SequenceStoreS3Access(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SequenceStoreS3Access> {
        public Builder s3Uri(String var1);

        public Builder s3AccessPointArn(String var1);

        public Builder accessLogLocation(String var1);
    }
}

